/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.sqlite.JDBC;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.utils.XmlUtils;

public class SpiderSVNEntriesParser
extends SpiderParser {
    private static final Pattern svnSQLiteFormatPattern = Pattern.compile("^SQLite format ");
    private static final Pattern svnXMLFormatPattern = Pattern.compile("<wc-entries");
    private static final Pattern svnTextFormatFileOrDirectoryPattern = Pattern.compile("^(file|dir)$");
    private static final Pattern svnRepoLocationPattern = Pattern.compile("^(http://|https://)", 2);
    private SpiderParam params;
    private static DocumentBuilder dBuilder;
    private Pattern SVN_ENTRIES_FILE_PATTERN = Pattern.compile("/\\.svn/entries$|/\\.svn/wc.db$");

    public SpiderSVNEntriesParser(SpiderParam spiderParam) {
        this.params = spiderParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        if (httpMessage == null || !this.params.isParseSVNEntries()) {
            return false;
        }
        log.debug((Object)"Parsing an SVN resource...");
        String string = httpMessage.getResponseBody().toString();
        String string2 = httpMessage.getRequestHeader().getURI().toString();
        Matcher matcher = svnSQLiteFormatPattern.matcher(string);
        Matcher matcher2 = svnXMLFormatPattern.matcher(string);
        if (matcher.find()) {
            try {
                Object object;
                File file = File.createTempFile("sqlite", null);
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(httpMessage.getResponseBody().getBytes());
                ((OutputStream)fileOutputStream).close();
                if (log.isDebugEnabled()) {
                    object = new JDBC();
                    log.debug((Object)("Created a temporary SQLite database file '" + file + "'"));
                    log.debug((Object)("SQLite JDBC Driver is version " + object.getMajorVersion() + "." + object.getMinorVersion()));
                }
                Class.forName("org.sqlite.JDBC");
                object = "jdbc:sqlite:" + file.getAbsolutePath();
                try (Connection connection = DriverManager.getConnection((String)object);){
                    if (connection != null) {
                        Statement statement = null;
                        ResultSet resultSet = null;
                        ResultSet resultSet2 = null;
                        ResultSet resultSet3 = null;
                        try {
                            Object object2;
                            String string3;
                            statement = connection.createStatement();
                            resultSet = statement.executeQuery("pragma USER_VERSION");
                            int n2 = 0;
                            if (resultSet.next()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Got a row from 'pragma USER_VERSION'");
                                }
                                n2 = resultSet.getInt(1);
                            }
                            if (n2 < 29) {
                                throw new Exception("The SVN Working Copy Format of the SQLite database should be >= 29. We found " + n2);
                            }
                            if (n2 > 31) {
                                throw new Exception("SVN Working Copy Format " + n2 + " is not supported at this time.  We support up to and including format 31 (~ SVN 1.8.5)");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Internal SVN Working Copy Format for " + file + " is " + n2));
                                log.debug((Object)"Refer to http://svn.apache.org/repos/asf/subversion/trunk/subversion/libsvn_wc/wc.h for more details!");
                            }
                            switch (n2) {
                                case 29: 
                                case 30: 
                                case 31: {
                                    resultSet2 = statement.executeQuery("select kind,local_relpath,'pristine/'||substr(checksum,7,2) || \"/\" || substr(checksum,7)|| \".svn-base\" from nodes order by wc_id");
                                }
                            }
                            while (resultSet2.next()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Got a Node from the SVN wc.db file (format " + n2 + ")"));
                                }
                                string3 = resultSet2.getString(1);
                                object2 = resultSet2.getString(2);
                                String string4 = resultSet2.getString(3);
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                log.debug((Object)"Found a file/directory name in the (SQLite based) SVN wc.db file");
                                this.processURL(httpMessage, n, "../" + (String)object2 + (string3.equals("dir") ? "/" : ""), string2);
                                if (string3.equals("dir")) {
                                    this.processURL(httpMessage, n, "../" + (String)object2 + "/.svn/wc.db", string2);
                                }
                                if (!string3.equals("file") || string4 == null || string4.length() <= 0) continue;
                                this.processURL(httpMessage, n, string4, string2);
                            }
                            resultSet3 = statement.executeQuery("select root from REPOSITORY order by id");
                            while (resultSet3.next()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Got a potential Repository from the SVN wc.db file (format " + n2 + ")"));
                                }
                                if ((string3 = resultSet3.getString(1)) == null || string3.length() <= 0 || !((Matcher)(object2 = svnRepoLocationPattern.matcher(string3))).find()) continue;
                                log.debug((Object)"Found an SVN repository location in the (SQLite based) SVN wc.db file");
                                this.processURL(httpMessage, n, string3 + "/", string2);
                            }
                        }
                        catch (Exception exception) {
                            log.error((Object)("Error executing SQL on temporary SVN SQLite database '" + (String)object + "': " + exception));
                        }
                        finally {
                            if (resultSet3 != null) {
                                resultSet3.close();
                            }
                            if (resultSet2 != null) {
                                resultSet2.close();
                            }
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    throw new SQLException("Could not open a JDBC connection to SQLite file " + file.getAbsolutePath());
                }
                catch (Exception exception) {
                    log.error((Object)("Error parsing temporary SVN SQLite database " + (String)object));
                }
                finally {
                    file.delete();
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                log.error((Object)("An error occurred trying to set up to parse the SQLite based file: " + exception));
                return true;
            }
        } else if (matcher2.find()) {
            Document document;
            try {
                document = dBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
            }
            catch (IOException | SAXException exception) {
                log.error((Object)("An error occurred trying to parse the XML based .svn/entries file: " + exception));
                return true;
            }
            NodeList nodeList = document.getElementsByTagName("entry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Matcher matcher3;
                Node node = nodeList.item(i);
                String string5 = ((Element)node).getAttribute("name");
                String string6 = ((Element)node).getAttribute("kind");
                String string7 = ((Element)node).getAttribute("url");
                String string8 = ((Element)node).getAttribute("copyfrom-url");
                if (string5 != null && string5.length() > 0) {
                    log.debug((Object)"Found a file/directory name in the (XML based) SVN < 1.4 entries file");
                    this.processURL(httpMessage, n, "../" + string5 + (string6.equals("dir") ? "/" : ""), string2);
                    if (string6.equals("file")) {
                        this.processURL(httpMessage, n, "text-base/" + string5 + ".svn-base", string2);
                    }
                    if (string6.equals("dir")) {
                        this.processURL(httpMessage, n, "../" + string5 + "/.svn/entries", string2);
                    }
                }
                if (string5 != null && string5.length() == 0 && string6.equals("dir") && (matcher3 = svnRepoLocationPattern.matcher(string7)).find()) {
                    log.debug((Object)"Found an SVN repository location in the (XML based) SVN < 1.4 entries file");
                    this.processURL(httpMessage, n, string7 + "/", string2);
                }
                if (!(matcher3 = svnRepoLocationPattern.matcher(string8)).find()) continue;
                log.debug((Object)"Found an SVN URL in the (XML based) SVN < 1.4 entries file");
                this.processURL(httpMessage, n, string8, string2);
            }
        } else {
            String[] stringArray;
            String string9 = null;
            for (String string10 : stringArray = string.split("\n")) {
                if (string10.length() > 0) {
                    Object object;
                    Matcher matcher4 = svnTextFormatFileOrDirectoryPattern.matcher(string10);
                    if (matcher4.find()) {
                        object = matcher4.group(0);
                        if (string9 != null && string9.length() > 0) {
                            log.debug((Object)"Found a file/directory name in the (text based) SVN 1.4/1.5/1.6 SVN entries file");
                            this.processURL(httpMessage, n, "../" + string9 + (((String)object).equals("dir") ? "/" : ""), string2);
                            if (((String)object).equals("file")) {
                                this.processURL(httpMessage, n, "text-base/" + string9 + ".svn-base", string2);
                            }
                            if (((String)object).equals("dir")) {
                                this.processURL(httpMessage, n, "../" + string9 + "/.svn/entries", string2);
                            }
                        }
                    } else {
                        object = svnRepoLocationPattern.matcher(string10);
                        if (((Matcher)object).find()) {
                            log.debug((Object)"Found an SVN repository location in the (text based) 1.4/1.5/1.6 SVN entries file");
                            this.processURL(httpMessage, n, string10 + "/", string2);
                        }
                    }
                }
                string9 = string10;
            }
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        Matcher matcher = this.SVN_ENTRIES_FILE_PATTERN.matcher(string);
        return matcher.find();
    }

    static {
        try {
            dBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)parserConfigurationException);
        }
    }
}

