/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger(ResolverXPointer.class.getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        Node resultNode = null;
        Document doc = uri.getOwnerElement().getOwnerDocument();
        String uriStr = uri.getNodeValue();
        if (ResolverXPointer.isXPointerSlash(uriStr)) {
            resultNode = doc;
        } else if (ResolverXPointer.isXPointerId(uriStr)) {
            Element start;
            String id = ResolverXPointer.getXPointerId(uriStr);
            resultNode = doc.getElementById(id);
            if (this.secureValidation && !XMLUtils.protectAgainstWrappingAttack(start = uri.getOwnerDocument().getDocumentElement(), id)) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", exArgs, uri, baseURI);
            }
            if (resultNode == null) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MissingID", exArgs, uri, baseURI);
            }
        }
        XMLSignatureInput result = new XMLSignatureInput(resultNode);
        result.setMIMEType("text/xml");
        if (baseURI != null && baseURI.length() > 0) {
            result.setSourceURI(baseURI.concat(uri.getNodeValue()));
        } else {
            result.setSourceURI(uri.getNodeValue());
        }
        return result;
    }

    @Override
    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriStr = uri.getNodeValue();
        return ResolverXPointer.isXPointerSlash(uriStr) || ResolverXPointer.isXPointerId(uriStr);
    }

    private static boolean isXPointerSlash(String uri) {
        return uri.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String uri) {
        if (uri.startsWith(XP) && uri.endsWith("))")) {
            String idPlusDelim = uri.substring(XP_LENGTH, uri.length() - 2);
            int idLen = idPlusDelim.length() - 1;
            if (idPlusDelim.charAt(0) == '\"' && idPlusDelim.charAt(idLen) == '\"' || idPlusDelim.charAt(0) == '\'' && idPlusDelim.charAt(idLen) == '\'') {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Id=" + idPlusDelim.substring(1, idLen));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String uri) {
        if (uri.startsWith(XP) && uri.endsWith("))")) {
            String idPlusDelim = uri.substring(XP_LENGTH, uri.length() - 2);
            int idLen = idPlusDelim.length() - 1;
            if (idPlusDelim.charAt(0) == '\"' && idPlusDelim.charAt(idLen) == '\"' || idPlusDelim.charAt(0) == '\'' && idPlusDelim.charAt(idLen) == '\'') {
                return idPlusDelim.substring(1, idLen);
            }
        }
        return null;
    }
}

