/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import com.sun.security.jgss.AuthorizationDataEntry;
import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.TokenTracker;
import sun.security.jgss.krb5.AcceptSecContextToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.InitSecContextToken;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.MessageToken;
import sun.security.jgss.krb5.MessageToken_v2;
import sun.security.jgss.krb5.MicToken;
import sun.security.jgss.krb5.MicToken_v2;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.krb5.WrapToken_v2;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

class Krb5Context
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    public static final int SESSION_KEY = 0;
    public static final int INITIATOR_SUBKEY = 1;
    public static final int ACCEPTOR_SUBKEY = 2;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private boolean delegPolicyState = false;
    private int mySeqNumber;
    private int peerSeqNumber;
    private int keySrc;
    private TokenTracker peerTokenTracker;
    private CipherHelper cipherHelper = null;
    private Object mySeqNumberLock = new Object();
    private Object peerSeqNumberLock = new Object();
    private EncryptionKey key;
    private Krb5NameElement myName;
    private Krb5NameElement peerName;
    private int lifetime;
    private boolean initiator;
    private ChannelBinding channelBinding;
    private Krb5CredElement myCred;
    private Krb5CredElement delegatedCred;
    private Cipher desCipher = null;
    private Credentials serviceCreds;
    private KrbApReq apReq;
    private final GSSCaller caller;
    private static final boolean DEBUG = Krb5Util.DEBUG;
    private boolean[] tktFlags;
    private String authTime;
    private AuthorizationDataEntry[] authzData;

    Krb5Context(GSSCaller caller, Krb5NameElement peerName, Krb5CredElement myCred, int lifetime) throws GSSException {
        if (peerName == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        this.caller = caller;
        this.peerName = peerName;
        this.myCred = myCred;
        this.lifetime = lifetime;
        this.initiator = true;
    }

    Krb5Context(GSSCaller caller, Krb5CredElement myCred) throws GSSException {
        this.caller = caller;
        this.myCred = myCred;
        this.initiator = false;
    }

    public Krb5Context(GSSCaller caller, byte[] interProcessToken) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    @Override
    public final boolean isTransferable() throws GSSException {
        return false;
    }

    @Override
    public final int getLifetime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void requestLifetime(int lifetime) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = lifetime;
        }
    }

    @Override
    public final void requestConf(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = value;
        }
    }

    @Override
    public final boolean getConfState() {
        return this.confState;
    }

    @Override
    public final void requestInteg(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = value;
        }
    }

    @Override
    public final boolean getIntegState() {
        return this.integState;
    }

    @Override
    public final void requestCredDeleg(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = value;
        }
    }

    @Override
    public final boolean getCredDelegState() {
        return this.credDelegState;
    }

    @Override
    public final void requestMutualAuth(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = value;
        }
    }

    @Override
    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    @Override
    public final void requestReplayDet(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = value;
        }
    }

    @Override
    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    @Override
    public final void requestSequenceDet(boolean value) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = value;
        }
    }

    @Override
    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    @Override
    public final void requestDelegPolicy(boolean value) {
        if (this.state == 1 && this.isInitiator()) {
            this.delegPolicyState = value;
        }
    }

    @Override
    public final boolean getDelegPolicyState() {
        return this.delegPolicyState;
    }

    @Override
    public final void requestAnonymity(boolean value) throws GSSException {
    }

    @Override
    public final boolean getAnonymityState() {
        return false;
    }

    final CipherHelper getCipherHelper(EncryptionKey ckey) throws GSSException {
        EncryptionKey cipherKey = null;
        if (this.cipherHelper == null) {
            cipherKey = this.getKey() == null ? ckey : this.getKey();
            this.cipherHelper = new CipherHelper(cipherKey);
        }
        return this.cipherHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int incrementMySequenceNumber() {
        int retVal;
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            retVal = this.mySeqNumber;
            this.mySeqNumber = retVal + 1;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetMySequenceNumber(int seqNumber) {
        if (DEBUG) {
            System.out.println("Krb5Context setting mySeqNumber to: " + seqNumber);
        }
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            this.mySeqNumber = seqNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetPeerSequenceNumber(int seqNumber) {
        if (DEBUG) {
            System.out.println("Krb5Context setting peerSeqNumber to: " + seqNumber);
        }
        Object object = this.peerSeqNumberLock;
        synchronized (object) {
            this.peerSeqNumber = seqNumber;
            this.peerTokenTracker = new TokenTracker(this.peerSeqNumber);
        }
    }

    final void setKey(int keySrc, EncryptionKey key) throws GSSException {
        this.key = key;
        this.keySrc = keySrc;
        this.cipherHelper = new CipherHelper(key);
    }

    public final int getKeySrc() {
        return this.keySrc;
    }

    private final EncryptionKey getKey() {
        return this.key;
    }

    final void setDelegCred(Krb5CredElement delegatedCred) {
        this.delegatedCred = delegatedCred;
    }

    final void setCredDelegState(boolean state) {
        this.credDelegState = state;
    }

    final void setMutualAuthState(boolean state) {
        this.mutualAuthState = state;
    }

    final void setReplayDetState(boolean state) {
        this.replayDetState = state;
    }

    final void setSequenceDetState(boolean state) {
        this.sequenceDetState = state;
    }

    final void setConfState(boolean state) {
        this.confState = state;
    }

    final void setIntegState(boolean state) {
        this.integState = state;
    }

    final void setDelegPolicyState(boolean state) {
        this.delegPolicyState = state;
    }

    @Override
    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public final Oid getMech() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public final GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.delegatedCred == null) {
            throw new GSSException(13);
        }
        return this.delegatedCred;
    }

    @Override
    public final boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public final boolean isProtReady() {
        return this.state == 3;
    }

    @Override
    public final byte[] initSecContext(InputStream is, int mechTokenSize) throws GSSException {
        byte[] retVal;
        block27: {
            retVal = null;
            InitSecContextToken token = null;
            int errorCode = 11;
            if (DEBUG) {
                System.out.println("Entered Krb5Context.initSecContext with state=" + Krb5Context.printState(this.state));
            }
            if (!this.isInitiator()) {
                throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
            }
            try {
                if (this.state == 1) {
                    this.state = 2;
                    errorCode = 13;
                    if (this.myCred == null) {
                        this.myCred = Krb5InitCredential.getInstance(this.caller, this.myName, 0);
                    } else if (!this.myCred.isInitiatorCredential()) {
                        throw new GSSException(errorCode, -1, "No TGT available");
                    }
                    this.myName = (Krb5NameElement)this.myCred.getName();
                    Credentials tgt = ((Krb5InitCredential)this.myCred).getKrb5Credentials();
                    this.checkPermission(this.peerName.getKrb5PrincipalName().getName(), "initiate");
                    final AccessControlContext acc = AccessController.getContext();
                    if (GSSUtil.useSubjectCredsOnly(this.caller)) {
                        KerberosTicket kerbTicket;
                        block26: {
                            kerbTicket = null;
                            try {
                                kerbTicket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                                    @Override
                                    public KerberosTicket run() throws Exception {
                                        return Krb5Util.getTicket(GSSCaller.CALLER_UNKNOWN, Krb5Context.this.myName.getKrb5PrincipalName().getName(), Krb5Context.this.peerName.getKrb5PrincipalName().getName(), acc);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                if (!DEBUG) break block26;
                                System.out.println("Attempt to obtain service ticket from the subject failed!");
                            }
                        }
                        if (kerbTicket != null) {
                            if (DEBUG) {
                                System.out.println("Found service ticket in the subject" + kerbTicket);
                            }
                            this.serviceCreds = Krb5Util.ticketToCreds(kerbTicket);
                        }
                    }
                    if (this.serviceCreds == null) {
                        if (DEBUG) {
                            System.out.println("Service ticket not found in the subject");
                        }
                        this.serviceCreds = Credentials.acquireServiceCreds(this.peerName.getKrb5PrincipalName().getName(), tgt);
                        if (GSSUtil.useSubjectCredsOnly(this.caller)) {
                            final Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                                @Override
                                public Subject run() {
                                    return Subject.getSubject(acc);
                                }
                            });
                            if (subject != null && !subject.isReadOnly()) {
                                final KerberosTicket kt = Krb5Util.credsToTicket(this.serviceCreds);
                                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                    @Override
                                    public Void run() {
                                        subject.getPrivateCredentials().add(kt);
                                        return null;
                                    }
                                });
                            } else if (DEBUG) {
                                System.out.println("Subject is readOnly;Kerberos Service ticket not stored");
                            }
                        }
                    }
                    errorCode = 11;
                    token = new InitSecContextToken(this, tgt, this.serviceCreds);
                    this.apReq = token.getKrbApReq();
                    retVal = ((InitialToken)token).encode();
                    this.myCred = null;
                    if (!this.getMutualAuthState()) {
                        this.state = 3;
                    }
                    if (DEBUG) {
                        System.out.println("Created InitSecContextToken:\n" + new HexDumpEncoder().encodeBuffer(retVal));
                    }
                    break block27;
                }
                if (this.state == 2) {
                    new AcceptSecContextToken(this, this.serviceCreds, this.apReq, is);
                    this.serviceCreds = null;
                    this.apReq = null;
                    this.state = 3;
                } else if (DEBUG) {
                    System.out.println(this.state);
                }
            }
            catch (KrbException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                GSSException gssException = new GSSException(errorCode, -1, e.getMessage());
                gssException.initCause(e);
                throw gssException;
            }
            catch (IOException e) {
                GSSException gssException = new GSSException(errorCode, -1, e.getMessage());
                gssException.initCause(e);
                throw gssException;
            }
        }
        return retVal;
    }

    @Override
    public final boolean isEstablished() {
        return this.state == 3;
    }

    @Override
    public final byte[] acceptSecContext(InputStream is, int mechTokenSize) throws GSSException {
        byte[] retVal = null;
        if (DEBUG) {
            System.out.println("Entered Krb5Context.acceptSecContext with state=" + Krb5Context.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                if (this.myCred == null) {
                    this.myCred = Krb5AcceptCredential.getInstance(this.caller, this.myName);
                } else if (!this.myCred.isAcceptorCredential()) {
                    throw new GSSException(13, -1, "No Secret Key available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                this.checkPermission(this.myName.getKrb5PrincipalName().getName(), "accept");
                EncryptionKey[] secretKeys = ((Krb5AcceptCredential)this.myCred).getKrb5EncryptionKeys();
                InitSecContextToken token = new InitSecContextToken(this, secretKeys, is);
                PrincipalName clientName = token.getKrbApReq().getClient();
                this.peerName = Krb5NameElement.getInstance(clientName);
                if (this.getMutualAuthState()) {
                    retVal = new AcceptSecContextToken(this, token.getKrbApReq()).encode();
                }
                this.myCred = null;
                this.state = 3;
            } else if (DEBUG) {
                System.out.println(this.state);
            }
        }
        catch (KrbException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        catch (IOException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        return retVal;
    }

    @Override
    public final int getWrapSizeLimit(int qop, boolean confReq, int maxTokSize) throws GSSException {
        int retVal = 0;
        if (this.cipherHelper.getProto() == 0) {
            retVal = WrapToken.getSizeLimit(qop, confReq, maxTokSize, this.getCipherHelper(null));
        } else if (this.cipherHelper.getProto() == 1) {
            retVal = WrapToken_v2.getSizeLimit(qop, confReq, maxTokSize, this.getCipherHelper(null));
        }
        return retVal;
    }

    @Override
    public final byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: data=[" + Krb5Context.getHexBytes(inBuf, offset, len) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] encToken = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken token = new WrapToken(this, msgProp, inBuf, offset, len);
                encToken = token.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 token = new WrapToken_v2(this, msgProp, inBuf, offset, len);
                encToken = token.encode();
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(encToken, 0, encToken.length) + "]");
            }
            return encToken;
        }
        catch (IOException e) {
            encToken = null;
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    public final int wrap(byte[] inBuf, int inOffset, int len, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        int retVal = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken token = new WrapToken(this, msgProp, inBuf, inOffset, len);
                retVal = token.encode(outBuf, outOffset);
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 token = new WrapToken_v2(this, msgProp, inBuf, inOffset, len);
                retVal = token.encode(outBuf, outOffset);
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(outBuf, outOffset, retVal) + "]");
            }
            return retVal;
        }
        catch (IOException e) {
            retVal = 0;
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    public final void wrap(byte[] inBuf, int offset, int len, OutputStream os, MessageProp msgProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] encToken = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken token = new WrapToken(this, msgProp, inBuf, offset, len);
                token.encode(os);
                if (DEBUG) {
                    encToken = token.encode();
                }
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 token = new WrapToken_v2(this, msgProp, inBuf, offset, len);
                token.encode(os);
                if (DEBUG) {
                    encToken = token.encode();
                }
            }
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(encToken, 0, encToken.length) + "]");
        }
    }

    @Override
    public final void wrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        byte[] data;
        try {
            data = new byte[is.available()];
            is.read(data);
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        this.wrap(data, 0, data.length, os, msgProp);
    }

    @Override
    public final byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: token=[" + Krb5Context.getHexBytes(inBuf, offset, len) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, " Unwrap called in invalid state!");
        }
        byte[] data = null;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken token = new WrapToken(this, inBuf, offset, len, msgProp);
            data = token.getData();
            this.setSequencingAndReplayProps(token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 token = new WrapToken_v2(this, inBuf, offset, len, msgProp);
            data = token.getData();
            this.setSequencingAndReplayProps(token, msgProp);
        }
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: data=[" + Krb5Context.getHexBytes(data, 0, data.length) + "]");
        }
        return data;
    }

    public final int unwrap(byte[] inBuf, int inOffset, int len, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        if (this.cipherHelper.getProto() == 0) {
            WrapToken token = new WrapToken(this, inBuf, inOffset, len, msgProp);
            len = token.getData(outBuf, outOffset);
            this.setSequencingAndReplayProps(token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 token = new WrapToken_v2(this, inBuf, inOffset, len, msgProp);
            len = token.getData(outBuf, outOffset);
            this.setSequencingAndReplayProps(token, msgProp);
        }
        return len;
    }

    public final int unwrap(InputStream is, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        int len = 0;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken token = new WrapToken(this, is, msgProp);
            len = token.getData(outBuf, outOffset);
            this.setSequencingAndReplayProps(token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 token = new WrapToken_v2(this, is, msgProp);
            len = token.getData(outBuf, outOffset);
            this.setSequencingAndReplayProps(token, msgProp);
        }
        return len;
    }

    @Override
    public final void unwrap(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        Krb5Token token;
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        byte[] data = null;
        if (this.cipherHelper.getProto() == 0) {
            token = new WrapToken(this, is, msgProp);
            data = ((WrapToken)token).getData();
            this.setSequencingAndReplayProps((MessageToken)token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            token = new WrapToken_v2(this, is, msgProp);
            data = ((WrapToken_v2)token).getData();
            this.setSequencingAndReplayProps((MessageToken_v2)token, msgProp);
        }
        try {
            os.write(data);
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    @Override
    public final byte[] getMIC(byte[] inMsg, int offset, int len, MessageProp msgProp) throws GSSException {
        byte[] micToken = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken token = new MicToken(this, msgProp, inMsg, offset, len);
                micToken = token.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 token = new MicToken_v2(this, msgProp, inMsg, offset, len);
                micToken = token.encode();
            }
            return micToken;
        }
        catch (IOException e) {
            micToken = null;
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    private int getMIC(byte[] inMsg, int offset, int len, byte[] outBuf, int outOffset, MessageProp msgProp) throws GSSException {
        int retVal = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken token = new MicToken(this, msgProp, inMsg, offset, len);
                retVal = token.encode(outBuf, outOffset);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 token = new MicToken_v2(this, msgProp, inMsg, offset, len);
                retVal = token.encode(outBuf, outOffset);
            }
            return retVal;
        }
        catch (IOException e) {
            retVal = 0;
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    private void getMIC(byte[] inMsg, int offset, int len, OutputStream os, MessageProp msgProp) throws GSSException {
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken token = new MicToken(this, msgProp, inMsg, offset, len);
                token.encode(os);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 token = new MicToken_v2(this, msgProp, inMsg, offset, len);
                token.encode(os);
            }
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
    }

    @Override
    public final void getMIC(InputStream is, OutputStream os, MessageProp msgProp) throws GSSException {
        byte[] data;
        try {
            data = new byte[is.available()];
            is.read(data);
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        this.getMIC(data, 0, data.length, os, msgProp);
    }

    @Override
    public final void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken token = new MicToken(this, inTok, tokOffset, tokLen, msgProp);
            token.verify(inMsg, msgOffset, msgLen);
            this.setSequencingAndReplayProps(token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 token = new MicToken_v2(this, inTok, tokOffset, tokLen, msgProp);
            token.verify(inMsg, msgOffset, msgLen);
            this.setSequencingAndReplayProps(token, msgProp);
        }
    }

    private void verifyMIC(InputStream is, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken token = new MicToken(this, is, msgProp);
            token.verify(inMsg, msgOffset, msgLen);
            this.setSequencingAndReplayProps(token, msgProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 token = new MicToken_v2(this, is, msgProp);
            token.verify(inMsg, msgOffset, msgLen);
            this.setSequencingAndReplayProps(token, msgProp);
        }
    }

    @Override
    public final void verifyMIC(InputStream is, InputStream msgStr, MessageProp mProp) throws GSSException {
        byte[] msg;
        try {
            msg = new byte[msgStr.available()];
            msgStr.read(msg);
        }
        catch (IOException e) {
            GSSException gssException = new GSSException(11, -1, e.getMessage());
            gssException.initCause(e);
            throw gssException;
        }
        this.verifyMIC(is, msg, 0, msg.length, mProp);
    }

    @Override
    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    @Override
    public final void dispose() throws GSSException {
        this.state = 4;
        this.delegatedCred = null;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    private void setSequencingAndReplayProps(MessageToken token, MessageProp prop) {
        if (this.replayDetState || this.sequenceDetState) {
            int seqNum = token.getSequenceNumber();
            this.peerTokenTracker.getProps(seqNum, prop);
        }
    }

    private void setSequencingAndReplayProps(MessageToken_v2 token, MessageProp prop) {
        if (this.replayDetState || this.sequenceDetState) {
            int seqNum = token.getSequenceNumber();
            this.peerTokenTracker.getProps(seqNum, prop);
        }
    }

    private void checkPermission(String principal, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServicePermission perm = new ServicePermission(principal, action);
            sm.checkPermission(perm);
        }
    }

    private static String getHexBytes(byte[] bytes, int pos, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int b1 = bytes[i] >> 4 & 0xF;
            int b2 = bytes[i] & 0xF;
            sb.append(Integer.toHexString(b1));
            sb.append(Integer.toHexString(b2));
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String printState(int state) {
        switch (state) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + state;
    }

    GSSCaller getCaller() {
        return this.caller;
    }

    @Override
    public Object inquireSecContext(InquireType type) throws GSSException {
        if (!this.isEstablished()) {
            throw new GSSException(12, -1, "Security context not established.");
        }
        switch (type) {
            case KRB5_GET_SESSION_KEY: {
                return new KerberosSessionKey(this.key);
            }
            case KRB5_GET_TKT_FLAGS: {
                return this.tktFlags.clone();
            }
            case KRB5_GET_AUTHZ_DATA: {
                if (this.isInitiator()) {
                    throw new GSSException(16, -1, "AuthzData not available on initiator side.");
                }
                return this.authzData == null ? null : (AuthorizationDataEntry[])this.authzData.clone();
            }
            case KRB5_GET_AUTHTIME: {
                return this.authTime;
            }
        }
        throw new GSSException(16, -1, "Inquire type not supported.");
    }

    public void setTktFlags(boolean[] tktFlags) {
        this.tktFlags = tktFlags;
    }

    public void setAuthTime(String authTime) {
        this.authTime = authTime;
    }

    public void setAuthzData(AuthorizationDataEntry[] authzData) {
        this.authzData = authzData;
    }

    static class KerberosSessionKey
    implements Key {
        private final EncryptionKey key;

        KerberosSessionKey(EncryptionKey key) {
            this.key = key;
        }

        @Override
        public String getAlgorithm() {
            return Integer.toString(this.key.getEType());
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.key.getBytes().clone();
        }

        public String toString() {
            return "Kerberos session key: etype: " + this.key.getEType() + "\n" + new HexDumpEncoder().encodeBuffer(this.key.getBytes());
        }
    }
}

