/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.PluginFactory;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.xslt.ConverterCapabilitiesImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentDeserializerImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentMergerImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentSerializerImpl;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public final class PluginFactoryImpl
extends PluginFactory
implements DocumentDeserializerFactory,
DocumentSerializerFactory,
DocumentMergerFactory {
    private static final ConverterCapabilities converterCap = new ConverterCapabilitiesImpl();

    public PluginFactoryImpl(ConverterInfo ci) {
        super(ci);
    }

    public DocumentSerializer createDocumentSerializer(Document doc) {
        return new DocumentSerializerImpl(this, doc);
    }

    public DocumentDeserializer createDocumentDeserializer(ConvertData cd) {
        return new DocumentDeserializerImpl(this, cd);
    }

    public Document createDeviceDocument(String str, InputStream inputStream) throws IOException {
        String ext = this.getDeviceFileExtension();
        DOMDocument domDoc = new DOMDocument(str, ext);
        domDoc.read(inputStream);
        return domDoc;
    }

    public Document createOfficeDocument(String name, InputStream is) throws IOException {
        GenericOfficeDocument doc = new GenericOfficeDocument(name);
        doc.read(is);
        return doc;
    }

    public Document createOfficeDocument(String name, InputStream is, boolean isZip) throws IOException {
        GenericOfficeDocument doc = new GenericOfficeDocument(name);
        doc.read(is, isZip);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceFileExtension() {
        Class<?> c = this.getClass();
        InputStream is = c.getResourceAsStream("XsltPlugin.properties");
        Properties props = new Properties();
        String ext = ".txt";
        String mimeType = null;
        ConverterInfo ci = this.getConverterInfo();
        Iterator<String> enumerate = ci.getDeviceMime();
        while (enumerate.hasNext()) {
            mimeType = enumerate.next();
        }
        try {
            props.load(is);
            String info = props.getProperty(mimeType);
            if (info != null) {
                ext = info;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ext;
    }

    public DocumentMerger createDocumentMerger(Document doc) {
        ConverterCapabilities cc = converterCap;
        DocumentMergerImpl merger = new DocumentMergerImpl(doc, cc);
        return merger;
    }
}

