/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import org.openoffice.xmerge.merger.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayLCSAlgorithm {
    public Difference[] computeDiffs(char[] orgSeq, char[] modSeq) {
        int orgSeqlen = orgSeq.length;
        int modSeqlen = modSeq.length;
        int[][] diffTable = this.createDiffTable(orgSeq, modSeq);
        ArrayList<Difference> diffResult = new ArrayList<Difference>();
        this.generateResult(diffTable, orgSeqlen, modSeqlen, diffResult);
        Difference[] diffArray = new Difference[]{};
        if (diffResult.size() > 0) {
            diffArray = new Difference[diffResult.size()];
            diffResult.toArray(diffArray);
        }
        diffTable = null;
        diffResult = null;
        return diffArray;
    }

    private int[][] createDiffTable(char[] orgSeq, char[] modSeq) {
        int i;
        int orgSeqlen = orgSeq.length + 1;
        int modSeqlen = modSeq.length + 1;
        int[][] diffTable = new int[orgSeqlen][];
        for (i = 0; i < orgSeqlen; ++i) {
            diffTable[i] = new int[modSeqlen];
        }
        for (i = 1; i < orgSeqlen; ++i) {
            for (int j = 1; j < modSeqlen; ++j) {
                diffTable[i][j] = orgSeq[i - 1] == modSeq[j - 1] ? diffTable[i - 1][j - 1] + 1 : (diffTable[i - 1][j] >= diffTable[i][j - 1] ? diffTable[i - 1][j] : diffTable[i][j - 1]);
            }
        }
        return diffTable;
    }

    private void generateResult(int[][] diffTable, int i, int j, ArrayList<Difference> diffVector) {
        if (i == 0 || j == 0) {
            if (i != 0 || j != 0) {
                if (j == 0) {
                    for (int cnt = 0; cnt < i; ++cnt) {
                        Difference diff = new Difference(2, cnt, j);
                        diffVector.add(diff);
                    }
                } else {
                    for (int cnt = 0; cnt < j; ++cnt) {
                        Difference diff = new Difference(1, i, cnt);
                        diffVector.add(diff);
                    }
                }
            }
            return;
        }
        if (diffTable[i - 1][j - 1] == diffTable[i][j] - 1 && diffTable[i - 1][j - 1] == diffTable[i - 1][j] && diffTable[i - 1][j - 1] == diffTable[i][j - 1]) {
            this.generateResult(diffTable, i - 1, j - 1, diffVector);
        } else if (diffTable[i - 1][j] > diffTable[i][j - 1]) {
            this.generateResult(diffTable, i - 1, j, diffVector);
            Difference diff = new Difference(2, i - 1, j);
            diffVector.add(diff);
        } else if (diffTable[i - 1][j] < diffTable[i][j - 1]) {
            this.generateResult(diffTable, i, j - 1, diffVector);
            Difference diff = new Difference(1, i, j - 1);
            diffVector.add(diff);
        } else {
            this.generateResult(diffTable, i - 1, j - 1, diffVector);
            Difference diff = new Difference(3, i - 1, j - 1);
            diffVector.add(diff);
        }
    }
}

