/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.commons.SetDestinationRequest;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.DestinationPane;
import org.pdfsam.ui.io.PdfVersionCombo;
import org.pdfsam.ui.io.PdfVersionConstrainedCheckBox;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.pdf.PdfVersion;
import org.springframework.context.annotation.Scope;

@Named(value="pdfDestinationPane")
@Scope(value="prototype")
public class PdfDestinationPane
extends DestinationPane
implements ModuleOwned,
RestorableView,
TaskParametersBuildStep<AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters>> {
    private PdfVersionCombo version;
    private PdfVersionConstrainedCheckBox compress;
    private String ownerModule = "";
    private UserContext userContext;

    public PdfDestinationPane(BrowsableField destination, String ownerModule, UserContext userContext) {
        super(destination);
        destination.setId(ownerModule + ".destination");
        RequireUtils.requireNotNull(userContext, "UserContext cannot be null");
        this.userContext = userContext;
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.version = new PdfVersionCombo(ownerModule);
        this.compress = new PdfVersionConstrainedCheckBox(PdfVersion.VERSION_1_5, ownerModule);
        this.compress.setText(DefaultI18nContext.getInstance().i18n("Compress output file/files"));
        HBox versionPane = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Output PDF version:")), this.version});
        versionPane.getStyleClass().addAll((Object[])Style.VITEM.css());
        versionPane.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{this.compress, versionPane});
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    public void enableSameAsSourceItem() {
        this.version.enableSameAsSourceItem();
    }

    @Override
    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener
    public void setDestination(SetDestinationRequest event) {
        if (!event.isFallback() || StringUtils.isBlank(this.destination().getTextField().getText()) && this.userContext.isUseSmartOutput()) {
            this.destination().setTextFromFile(event.getFootprint());
        }
    }

    @Override
    public void apply(AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters> builder, Consumer<String> onError) {
        builder.compress(this.compress.isSelected());
        if (this.overwrite().isSelected()) {
            builder.existingOutput(ExistingOutputPolicy.OVERWRITE);
        }
        builder.version(((PdfVersionCombo.PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion());
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("compress", Boolean.toString(this.compress.isSelected()));
        data.put("overwrite", Boolean.toString(this.overwrite().isSelected()));
        data.put("version", ((PdfVersionCombo.PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion().toString());
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.version.initializeState();
        this.compress.setSelected(Boolean.valueOf(data.get("compress")));
        this.overwrite().setSelected(Boolean.valueOf(data.get("overwrite")).booleanValue());
        Optional.ofNullable(data.get("version")).map(PdfVersion::valueOf).map(PdfVersionCombo.DefaultPdfVersionComboItem::new).ifPresent(v -> this.version.getSelectionModel().select(v));
    }
}

