/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.sejda.core.writer.xmlgraphics.AbstractImageWriterAdapter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;

abstract class BaseImageIOWriterAdapter<T extends AbstractPdfToImageParameters>
extends AbstractImageWriterAdapter<T> {
    private ImageWriter adapted = null;

    BaseImageIOWriterAdapter(String imageFormat) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(imageFormat);
        if (writers == null || !writers.hasNext()) {
            throw new IllegalArgumentException(String.format("Unable to find an ImageWriter for the format %s", imageFormat));
        }
        this.adapted = writers.next();
    }

    @Override
    public void openWriteDestination(OutputStream destination, T params) {
        this.setOutputStream(destination);
    }

    @Override
    public void write(RenderedImage image, T params) throws TaskIOException {
        if (this.adapted == null) {
            throw new TaskIOException("No ImageWriter available");
        }
        if (this.getOutputDestination() == null) {
            throw new TaskIOException("Cannot call write before opening the write destination");
        }
        ImageWriteParam imageWriterParams = this.newImageWriterParams(params);
        ImageOutputStream imageOut = null;
        try {
            imageOut = ImageIO.createImageOutputStream(this.getOutputDestination());
            this.adapted.setOutput(imageOut);
            this.adapted.write(null, new IIOImage(image, null, null), imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException(e);
        }
    }

    abstract ImageWriteParam newImageWriterParams(T var1);

    ImageWriter getAdapted() {
        return this.adapted;
    }

    @Override
    public boolean supportMultiImage() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.adapted != null) {
            this.adapted.dispose();
        }
        this.adapted = null;
        super.close();
    }
}

