/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.input.ContentStreamParser;
import org.sejda.sambox.output.ContentStreamWriter;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.sejda.sambox.pdmodel.interactive.form.AppearanceStyle;
import org.sejda.sambox.pdmodel.interactive.form.PDDefaultAppearanceString;
import org.sejda.sambox.pdmodel.interactive.form.PDListBox;
import org.sejda.sambox.pdmodel.interactive.form.PDTextField;
import org.sejda.sambox.pdmodel.interactive.form.PDVariableText;
import org.sejda.sambox.pdmodel.interactive.form.PlainText;
import org.sejda.sambox.pdmodel.interactive.form.PlainTextFormatter;

class AppearanceGeneratorHelper {
    private static final Operator BMC = Operator.getOperator("BMC");
    private static final Operator EMC = Operator.getOperator("EMC");
    private final PDVariableText field;
    private final PDDefaultAppearanceString defaultAppearance;
    private String value;
    private static final int[] HIGHLIGHT_COLOR = new int[]{153, 193, 215};
    private static final int FONTSCALE = 1000;
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final float DEFAULT_PADDING = 0.5f;

    AppearanceGeneratorHelper(PDVariableText field) throws IOException {
        this.field = field;
        this.defaultAppearance = field.getDefaultAppearanceString();
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            PDAppearanceStream appearanceStream;
            PDAppearanceEntry appearance;
            PDFormFieldAdditionalActions actions = this.field.getActions();
            if (actions != null && actions.getF() != null && widget.getCOSObject().getDictionaryObject(COSName.AP) == null) continue;
            PDAppearanceDictionary appearanceDict = widget.getAppearance();
            if (appearanceDict == null) {
                appearanceDict = new PDAppearanceDictionary();
                widget.setAppearance(appearanceDict);
            }
            if ((appearance = appearanceDict.getNormalAppearance()).isStream()) {
                appearanceStream = appearance.getAppearanceStream();
            } else {
                appearanceStream = new PDAppearanceStream();
                appearanceStream.setBBox(widget.getRectangle().createRetranslatedRectangle());
                appearanceDict.setNormalAppearance(appearanceStream);
            }
            if (widget.getAppearanceCharacteristics() != null || appearanceStream.getContentStream().getLength() == 0) {
                this.initializeAppearanceContent(widget, appearanceStream);
            }
            this.setAppearanceContent(widget, appearanceStream);
        }
    }

    private void initializeAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        try (PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream);){
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics = widget.getAppearanceCharacteristics();
            if (appearanceCharacteristics != null) {
                PDBorderStyleDictionary borderStyle;
                float lineWidth = 0.0f;
                PDColor borderColour = appearanceCharacteristics.getBorderColour();
                if (borderColour != null) {
                    contents.setNonStrokingColor(borderColour);
                    lineWidth = 1.0f;
                }
                if ((borderStyle = widget.getBorderStyle()) != null && borderStyle.getWidth() > 0.0f) {
                    lineWidth = borderStyle.getWidth();
                }
                if (lineWidth > 0.0f) {
                    contents.setLineWidth(lineWidth);
                    PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
                    PDRectangle clipRect = this.applyPadding(bbox, Math.max(0.5f, lineWidth / 2.0f));
                    contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
                    contents.closeAndStroke();
                }
            }
        }
    }

    private List<Object> tokenize(PDAppearanceStream appearanceStream) throws IOException {
        return new ContentStreamParser(appearanceStream).tokens();
    }

    private void setAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        this.defaultAppearance.copyNeededResourcesTo(appearanceStream);
        try (ContentStreamWriter writer = new ContentStreamWriter(CountingWritableByteChannel.from(appearanceStream.getCOSStream().createUnfilteredStream()));){
            List<Object> tokens = this.tokenize(appearanceStream);
            int bmcIndex = tokens.indexOf(BMC);
            if (bmcIndex == -1) {
                writer.writeTokens(tokens);
                writer.writeTokens(Arrays.asList(COSName.TX, BMC));
            } else {
                writer.writeTokens(tokens.subList(0, bmcIndex + 1));
            }
            this.insertGeneratedAppearance(widget, appearanceStream, writer);
            int emcIndex = tokens.indexOf(EMC);
            if (emcIndex == -1) {
                writer.writeTokens(EMC);
            } else {
                writer.writeTokens(tokens.subList(emcIndex, tokens.size()));
            }
        }
    }

    private void insertGeneratedAppearance(PDAnnotationWidget widget, PDAppearanceStream appearanceStream, ContentStreamWriter writer) throws IOException {
        float y;
        PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream, writer);
        appearanceStream.setMatrix(new AffineTransform());
        appearanceStream.setFormType(1);
        float borderWidth = 0.0f;
        if (widget.getBorderStyle() != null) {
            borderWidth = widget.getBorderStyle().getWidth();
        }
        PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
        PDRectangle clipRect = this.applyPadding(bbox, Math.max(1.0f, borderWidth));
        PDRectangle contentRect = this.applyPadding(clipRect, Math.max(1.0f, borderWidth));
        contents.saveGraphicsState();
        contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
        contents.clip();
        PDFont font = this.field.getDefaultAppearanceString().getFont();
        float fontSize = this.calculateFontSize(font, contentRect);
        if (this.field instanceof PDListBox) {
            this.insertGeneratedSelectionHighlight(contents, appearanceStream, font, fontSize);
        }
        contents.beginText();
        this.field.getDefaultAppearanceString().writeTo(contents, fontSize);
        float fontScaleY = fontSize / 1000.0f;
        float fontBoundingBoxAtSize = font.getBoundingBox().getHeight() * fontScaleY;
        float fontCapAtSize = font.getFontDescriptor().getCapHeight() * fontScaleY;
        float fontDescentAtSize = font.getFontDescriptor().getDescent() * fontScaleY;
        if (this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline()) {
            y = contentRect.getUpperRightY() - fontBoundingBoxAtSize;
        } else if (fontCapAtSize > clipRect.getHeight()) {
            y = clipRect.getLowerLeftY() + -fontDescentAtSize;
        } else {
            y = clipRect.getLowerLeftY() + (clipRect.getHeight() - fontCapAtSize) / 2.0f;
            if (y - clipRect.getLowerLeftY() < -fontDescentAtSize) {
                float fontDescentBased = -fontDescentAtSize + contentRect.getLowerLeftY();
                float fontCapBased = contentRect.getHeight() - contentRect.getLowerLeftY() - fontCapAtSize;
                y = Math.min(fontDescentBased, Math.max(y, fontCapBased));
            }
        }
        float x = contentRect.getLowerLeftX();
        if (this.shallComb()) {
            this.insertGeneratedCombAppearance(contents, appearanceStream, font, fontSize);
        } else if (this.field instanceof PDListBox) {
            this.insertGeneratedListboxAppearance(contents, appearanceStream, contentRect, font, fontSize);
        } else {
            PlainText textContent = new PlainText(this.value);
            AppearanceStyle appearanceStyle = new AppearanceStyle();
            appearanceStyle.setFont(font);
            appearanceStyle.setFontSize(fontSize);
            appearanceStyle.setLeading(font.getBoundingBox().getHeight() * fontScaleY);
            PlainTextFormatter formatter = new PlainTextFormatter.Builder(contents).style(appearanceStyle).text(textContent).width(contentRect.getWidth()).wrapLines(this.isMultiLine()).initialOffset(x, y).textAlign(this.field.getQ()).build();
            formatter.format();
        }
        contents.endText();
        contents.restoreGraphicsState();
    }

    private boolean isMultiLine() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline();
    }

    private boolean shallComb() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isComb() && !((PDTextField)this.field).isMultiline() && !((PDTextField)this.field).isPassword() && !((PDTextField)this.field).isFileSelect();
    }

    private void insertGeneratedCombAppearance(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDFont font, float fontSize) throws IOException {
        int maxLen = ((PDTextField)this.field).getMaxLen();
        int numChars = Math.min(this.value.length(), maxLen);
        PDRectangle paddingEdge = this.applyPadding(appearanceStream.getBBox(), 1.0f);
        float combWidth = appearanceStream.getBBox().getWidth() / (float)maxLen;
        float ascentAtFontSize = font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
        float baselineOffset = paddingEdge.getLowerLeftY() + (appearanceStream.getBBox().getHeight() - ascentAtFontSize) / 2.0f;
        float prevCharWidth = 0.0f;
        float currCharWidth = 0.0f;
        float xOffset = combWidth / 2.0f;
        String combString = "";
        for (int i = 0; i < numChars; ++i) {
            combString = this.value.substring(i, i + 1);
            currCharWidth = font.getStringWidth(combString) / 1000.0f * fontSize / 2.0f;
            xOffset = xOffset + prevCharWidth / 2.0f - currCharWidth / 2.0f;
            contents.newLineAtOffset(xOffset, baselineOffset);
            contents.showText(combString);
            baselineOffset = 0.0f;
            prevCharWidth = currCharWidth;
            xOffset = combWidth;
        }
    }

    private void insertGeneratedSelectionHighlight(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDFont font, float fontSize) throws IOException {
        List<Integer> indexEntries = ((PDListBox)this.field).getSelectedOptionsIndex();
        List<String> values = ((PDListBox)this.field).getValue();
        List<String> options = ((PDListBox)this.field).getOptionsExportValues();
        int selectedIndex = 0;
        if (!values.isEmpty() && !options.isEmpty()) {
            selectedIndex = !indexEntries.isEmpty() ? indexEntries.get(0).intValue() : options.indexOf(values.get(0));
        }
        int topIndex = ((PDListBox)this.field).getTopIndex();
        float highlightBoxHeight = font.getBoundingBox().getHeight() * fontSize / 1000.0f - 2.0f;
        PDRectangle paddingEdge = this.applyPadding(appearanceStream.getBBox(), 1.0f);
        contents.setNonStrokingColor(HIGHLIGHT_COLOR[0], HIGHLIGHT_COLOR[1], HIGHLIGHT_COLOR[2]);
        contents.addRect(paddingEdge.getLowerLeftX(), paddingEdge.getUpperRightY() - highlightBoxHeight * (float)(selectedIndex - topIndex + 1), paddingEdge.getWidth(), highlightBoxHeight);
        contents.fill();
        contents.setNonStrokingColor(0);
    }

    private void insertGeneratedListboxAppearance(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDRectangle contentRect, PDFont font, float fontSize) throws IOException {
        int topIndex;
        contents.setNonStrokingColor(0);
        int q = this.field.getQ();
        if (q == 1 || q == 2) {
            float fieldWidth = appearanceStream.getBBox().getWidth();
            float stringWidth = font.getStringWidth(this.value) / 1000.0f * fontSize;
            float adjustAmount = fieldWidth - stringWidth - 4.0f;
            if (q == 1) {
                adjustAmount /= 2.0f;
            }
            contents.newLineAtOffset(adjustAmount, 0.0f);
        } else if (q != 0) {
            throw new IOException("Error: Unknown justification value:" + q);
        }
        List<String> options = ((PDListBox)this.field).getOptionsDisplayValues();
        int numOptions = options.size();
        float yTextPos = contentRect.getUpperRightY();
        for (int i = topIndex = ((PDListBox)this.field).getTopIndex(); i < numOptions; ++i) {
            if (i == topIndex) {
                yTextPos -= font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            } else {
                yTextPos -= font.getBoundingBox().getHeight() / 1000.0f * fontSize;
                contents.beginText();
            }
            contents.newLineAtOffset(contentRect.getLowerLeftX(), yTextPos);
            contents.showText(options.get(i));
            if (i - topIndex == numOptions - 1) continue;
            contents.endText();
        }
    }

    private float calculateFontSize(PDFont font, PDRectangle contentRect) throws IOException {
        float fontSize = this.defaultAppearance.getFontSize();
        if (fontSize == 0.0f) {
            if (this.isMultiLine()) {
                return 12.0f;
            }
            float yScalingFactor = 1000.0f * font.getFontMatrix().getScaleY();
            float xScalingFactor = 1000.0f * font.getFontMatrix().getScaleX();
            float width = font.getStringWidth(this.value) * font.getFontMatrix().getScaleX();
            float widthBasedFontSize = contentRect.getWidth() / width * xScalingFactor;
            float height = (font.getFontDescriptor().getCapHeight() + -font.getFontDescriptor().getDescent()) * font.getFontMatrix().getScaleY();
            if (height <= 0.0f) {
                height = font.getBoundingBox().getHeight() * font.getFontMatrix().getScaleY();
            }
            float heightBasedFontSize = contentRect.getHeight() / height * yScalingFactor;
            return Math.min(heightBasedFontSize, widthBasedFontSize);
        }
        return fontSize;
    }

    private PDRectangle resolveBoundingBox(PDAnnotationWidget fieldWidget, PDAppearanceStream appearanceStream) {
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        return boundingBox;
    }

    private PDRectangle applyPadding(PDRectangle box, float padding) {
        return new PDRectangle(box.getLowerLeftX() + padding, box.getLowerLeftY() + padding, box.getWidth() - 2.0f * padding, box.getHeight() - 2.0f * padding);
    }
}

