/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.TagBreakpoint;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EvalInstrumentListener;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultStandardInstrumentListener;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TagBreakpointFactory {
    private static final boolean TRACE = false;
    private static final PrintStream OUT = System.out;
    private static final String BREAKPOINT_NAME = "TAG BREAKPOINT";
    private static final Comparator<Map.Entry<SyntaxTag, TagBreakpointImpl>> BREAKPOINT_COMPARATOR = new Comparator<Map.Entry<SyntaxTag, TagBreakpointImpl>>(){

        @Override
        public int compare(Map.Entry<SyntaxTag, TagBreakpointImpl> entry1, Map.Entry<SyntaxTag, TagBreakpointImpl> entry2) {
            return entry1.getKey().name().compareTo(entry2.getKey().name());
        }
    };
    private final Debugger debugger;
    private final Debugger.BreakpointCallback breakpointCallback;
    private final Debugger.WarningLog warningLog;
    private final Map<SyntaxTag, TagBreakpointImpl> tagToBreakpoint = new HashMap<SyntaxTag, TagBreakpointImpl>();
    @CompilerDirectives.CompilationFinal
    private boolean breakpointsActive = true;
    private final CyclicAssumption breakpointsActiveUnchanged = new CyclicAssumption("TAG BREAKPOINT globally active");

    @CompilerDirectives.TruffleBoundary
    private static void trace(String format, Object ... args) {
    }

    TagBreakpointFactory(Debugger debugger, Debugger.BreakpointCallback breakpointCallback, Debugger.WarningLog warningLog) {
        this.debugger = debugger;
        this.breakpointCallback = breakpointCallback;
        this.warningLog = warningLog;
        debugger.getInstrumenter().addProbeListener(new DefaultProbeListener(){

            @Override
            public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
                TagBreakpointImpl breakpoint = (TagBreakpointImpl)TagBreakpointFactory.this.tagToBreakpoint.get(tag);
                if (breakpoint != null) {
                    breakpoint.attach(probe);
                }
            }
        });
    }

    void setActive(boolean breakpointsActive) {
        if (this.breakpointsActive != breakpointsActive) {
            this.breakpointsActiveUnchanged.invalidate();
            this.breakpointsActive = breakpointsActive;
        }
    }

    List<TagBreakpoint> getAll() {
        ArrayList<Map.Entry<SyntaxTag, TagBreakpointImpl>> entries = new ArrayList<Map.Entry<SyntaxTag, TagBreakpointImpl>>(this.tagToBreakpoint.entrySet());
        Collections.sort(entries, BREAKPOINT_COMPARATOR);
        ArrayList<TagBreakpoint> breakpoints = new ArrayList<TagBreakpoint>(entries.size());
        for (Map.Entry<SyntaxTag, TagBreakpointImpl> entry : entries) {
            breakpoints.add(entry.getValue());
        }
        return breakpoints;
    }

    TagBreakpoint create(int ignoreCount, SyntaxTag tag, boolean oneShot) throws IOException {
        TagBreakpointImpl breakpoint = this.tagToBreakpoint.get(tag);
        if (breakpoint == null) {
            breakpoint = new TagBreakpointImpl(ignoreCount, tag, oneShot);
            this.tagToBreakpoint.put(tag, breakpoint);
            for (Probe probe : this.debugger.getInstrumenter().findProbesTaggedAs(tag)) {
                breakpoint.attach(probe);
            }
        } else {
            if (ignoreCount == breakpoint.getIgnoreCount()) {
                throw new IOException("TAG BREAKPOINT already set for tag " + tag.name());
            }
            breakpoint.setIgnoreCount(ignoreCount);
        }
        return breakpoint;
    }

    TagBreakpoint get(SyntaxTag tag) {
        return this.tagToBreakpoint.get(tag);
    }

    void disposeOneShots() {
        ArrayList<TagBreakpointImpl> breakpoints = new ArrayList<TagBreakpointImpl>(this.tagToBreakpoint.values());
        for (TagBreakpointImpl breakpoint : breakpoints) {
            if (!breakpoint.isOneShot()) continue;
            breakpoint.dispose();
        }
    }

    private void forget(TagBreakpointImpl breakpoint) {
        this.tagToBreakpoint.remove(breakpoint.getTag());
    }

    private final class TagBreakpointImpl
    extends TagBreakpoint
    implements EvalInstrumentListener {
        private static final String SHOULD_NOT_HAPPEN = "TagBreakpointImpl:  should not happen";
        private final SyntaxTag tag;
        private Assumption breakpointsActiveAssumption;
        @CompilerDirectives.CompilationFinal
        private boolean isEnabled;
        private Assumption enabledUnchangedAssumption;
        private Source conditionSource;
        private List<ProbeInstrument> instruments;

        private TagBreakpointImpl(int ignoreCount, SyntaxTag tag, boolean oneShot) {
            super(Breakpoint.State.ENABLED, ignoreCount, oneShot);
            this.instruments = new ArrayList<ProbeInstrument>();
            this.tag = tag;
            this.breakpointsActiveAssumption = TagBreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            this.isEnabled = true;
            this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("TAG BREAKPOINT enabled state unchanged");
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled) {
                switch (this.getState()) {
                    case ENABLED: {
                        assert (!enabled) : "TagBreakpointImpl:  should not happen";
                        this.doSetEnabled(false);
                        this.changeState(Breakpoint.State.DISABLED);
                        break;
                    }
                    case DISABLED: {
                        assert (enabled) : "TagBreakpointImpl:  should not happen";
                        this.doSetEnabled(true);
                        this.changeState(Breakpoint.State.ENABLED);
                        break;
                    }
                    case DISPOSED: {
                        assert (false) : "breakpoint disposed";
                        break;
                    }
                    default: {
                        assert (false) : "TagBreakpointImpl:  should not happen";
                        break;
                    }
                }
            }
        }

        @Override
        public void setCondition(String expr) throws IOException {
            if (this.conditionSource != null || expr != null) {
                ArrayList<Probe> probes = new ArrayList<Probe>();
                for (ProbeInstrument instrument : this.instruments) {
                    probes.add(instrument.getProbe());
                    instrument.dispose();
                }
                this.instruments.clear();
                this.conditionSource = Source.fromText(expr, "breakpoint condition for text: " + expr);
                for (Probe probe : probes) {
                    this.attach(probe);
                }
            }
        }

        @Override
        public Source getCondition() {
            return this.conditionSource;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void dispose() {
            if (this.getState() != Breakpoint.State.DISPOSED) {
                for (ProbeInstrument instrument : this.instruments) {
                    instrument.dispose();
                }
                this.changeState(Breakpoint.State.DISPOSED);
                TagBreakpointFactory.this.forget(this);
            }
        }

        private void attach(Probe newProbe) {
            if (this.getState() == Breakpoint.State.DISPOSED) {
                throw new IllegalStateException("Attempt to attach a disposed TAG BREAKPOINT");
            }
            ProbeInstrument newInstrument = null;
            Instrumenter instrumenter = TagBreakpointFactory.this.debugger.getInstrumenter();
            if (this.conditionSource == null) {
                newInstrument = instrumenter.attach(newProbe, new UnconditionalTagBreakInstrumentListener(), TagBreakpointFactory.BREAKPOINT_NAME);
            } else {
                instrumenter.attach(newProbe, this.conditionSource, this, TagBreakpointFactory.BREAKPOINT_NAME, null);
            }
            this.instruments.add(newInstrument);
            this.changeState(this.isEnabled ? Breakpoint.State.ENABLED : Breakpoint.State.DISABLED);
        }

        private void doSetEnabled(boolean enabled) {
            if (this.isEnabled != enabled) {
                this.enabledUnchangedAssumption.invalidate();
                this.isEnabled = enabled;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private String getShortDescription() {
            return "TAG BREAKPOINT@" + this.tag.name();
        }

        private void changeState(Breakpoint.State after) {
            this.setState(after);
        }

        private void doBreak(Node node, VirtualFrame vFrame) {
            if (this.incrHitCountCheckIgnore()) {
                TagBreakpointFactory.this.breakpointCallback.haltedAt(node, vFrame.materialize(), TagBreakpointFactory.BREAKPOINT_NAME);
            }
        }

        private void nodeEnter(Node astNode, VirtualFrame vFrame) {
            try {
                this.breakpointsActiveAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.breakpointsActiveAssumption = TagBreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            }
            try {
                this.enabledUnchangedAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("LineBreakpoint enabled state unchanged");
            }
            if (TagBreakpointFactory.this.breakpointsActive && this.isEnabled) {
                if (this.isOneShot()) {
                    this.dispose();
                }
                this.doBreak(astNode, vFrame);
            }
        }

        @Override
        public void onExecution(Node node, VirtualFrame vFrame, Object result) {
            if (result instanceof Boolean) {
                boolean condition = (Boolean)result;
                if (condition) {
                    this.nodeEnter(node, vFrame);
                }
            } else {
                this.onFailure(node, vFrame, new RuntimeException("breakpint failure = non-boolean condition " + result.toString()));
            }
        }

        @Override
        public void onFailure(Node node, VirtualFrame vFrame, Exception ex) {
            this.addExceptionWarning(ex);
            this.nodeEnter(node, vFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private void addExceptionWarning(Exception ex) {
            TagBreakpointFactory.this.warningLog.addWarning(String.format("Exception in %s:  %s", this.getShortDescription(), ex.getMessage()));
        }

        @Override
        public String getLocationDescription() {
            return "Tag " + this.tag.name();
        }

        @Override
        public SyntaxTag getTag() {
            return this.tag;
        }

        private final class UnconditionalTagBreakInstrumentListener
        extends DefaultStandardInstrumentListener {
            private UnconditionalTagBreakInstrumentListener() {
            }

            @Override
            public void onEnter(Probe probe, Node node, VirtualFrame vFrame) {
                TagBreakpointImpl.this.nodeEnter(node, vFrame);
            }
        }
    }
}

