/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

final class JavaFunctionNode
extends RootNode {
    JavaFunctionNode() {
        super(JavaInteropLanguage.class, null, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JavaInterop.JavaFunctionObject receiver = (JavaInterop.JavaFunctionObject)ForeignAccess.getReceiver(frame);
        List<Object> args = ForeignAccess.getArguments(frame);
        return JavaFunctionNode.execute(receiver, args.toArray());
    }

    static Object execute(JavaInterop.JavaFunctionObject receiver, Object[] args) {
        return JavaFunctionNode.execute(receiver.method, receiver.obj, args);
    }

    static Object execute(Method method, Object obj, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof JavaInterop.JavaObject)) continue;
            args[i] = ((JavaInterop.JavaObject)args[i]).obj;
        }
        try {
            Object ret = method.invoke(obj, args);
            if (JavaInterop.isPrimitive(ret)) {
                return ret;
            }
            return JavaInterop.asTruffleObject(ret);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

