define(
    [],
    function() {
        "use strict";

        var config = {
            IS_CLOUD: false,

            CLOUD_AUTH_HOST: 'https://account.ubnt.com',

            CLOUD_DASHBOARD_HOST: 'https://unifi.ubnt.com',

            ENABLE_GOOGLE_ANALYTICS: false,

            GOOGLE_ANALYTICS_TRACKING_ID: 'UA-2432820-22'
        };

        var cloudConfig = {
            USE_WEBRTC: true,

            CLOUD_AUTH_HOST: '_CLOUD_AUTH_HOST',

            CLOUD_DASHBOARD_HOST: '_CLOUD_DASHBOARD_HOST',

            STUN_HOST: '_STUN_HOST',
            TURN_CREDENTIAL_API_ENDPOINT: "/api/airos/v1/unifi/turn/creds?username=",

            SSO_API_HOST: '_SSO_API_HOST',
            SSO_API_ENDPOINT: '/api/sso/v1/user/self',

            UNIFI_WSS_HOST: '_UNIFI_WSS_HOST',
            UNIFI_WSS_ENDPOINT: '/api/airos/v1/unifi/events',

            CLOUD_API_HOST: '_CLOUD_API_HOST',
            CLOUD_API_ENDPOINT: '/api/airos/v1/unifi/devices',
            CLOUD_API_PAGE_SIZE: 5000,

            ENABLE_CLOUD_LOGGING: true,

            ENABLE_GOOGLE_ANALYTICS: false
        };

        if (config.IS_CLOUD) {
            for (var key in cloudConfig) {
                if (cloudConfig.hasOwnProperty(key)){
                    config[key] = cloudConfig[key];
                }
            }
        }

        return config;
    }
);
