/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterExtension;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

public class Javac
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private static final String JAVAC19 = "javac1.9";
    private static final String JAVAC18 = "javac1.8";
    private static final String JAVAC17 = "javac1.7";
    private static final String JAVAC16 = "javac1.6";
    private static final String JAVAC15 = "javac1.5";
    private static final String JAVAC14 = "javac1.4";
    private static final String JAVAC13 = "javac1.3";
    private static final String JAVAC12 = "javac1.2";
    private static final String JAVAC11 = "javac1.1";
    private static final String MODERN = "modern";
    private static final String CLASSIC = "classic";
    private static final String EXTJAVAC = "extJavac";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean depend = false;
    private boolean verbose = false;
    private String targetAttribute;
    private Path bootclasspath;
    private Path extdirs;
    private Boolean includeAntRuntime;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private String forkedExecutable = null;
    private boolean nowarn = false;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private FacadeTaskHelper facade = null;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private Map<String, Long> packageInfos = new HashMap<String, Long>();
    private String source;
    private String debugLevel;
    private File tmpDir;
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    private CompilerAdapter nestedAdapter = null;
    private boolean createMissingPackageInfoClass = true;
    private static final byte[] PACKAGE_INFO_CLASS_HEADER = new byte[]{-54, -2, -70, -66, 0, 0, 0, 49, 0, 7, 7, 0, 5, 7, 0, 6, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 17, 112, 97, 99, 107, 97, 103, 101, 45, 105, 110, 102, 111, 46, 106, 97, 118, 97, 1};
    private static final byte[] PACKAGE_INFO_CLASS_FOOTER = new byte[]{47, 112, 97, 99, 107, 97, 103, 101, 45, 105, 110, 102, 111, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 2, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 2, 0, 4};

    public Javac() {
        this.facade = new FacadeTaskHelper(this.assumedJavaVersion());
    }

    private String assumedJavaVersion() {
        if (JavaEnvUtils.isJavaVersion("1.4")) {
            return JAVAC14;
        }
        if (JavaEnvUtils.isJavaVersion("1.5")) {
            return JAVAC15;
        }
        if (JavaEnvUtils.isJavaVersion("1.6")) {
            return JAVAC16;
        }
        if (JavaEnvUtils.isJavaVersion("1.7")) {
            return JAVAC17;
        }
        if (JavaEnvUtils.isJavaVersion("1.8")) {
            return JAVAC18;
        }
        if (JavaEnvUtils.isJavaVersion("1.9")) {
            return JAVAC19;
        }
        return CLASSIC;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String v) {
        this.debugLevel = v;
    }

    public String getSource() {
        return this.source != null ? this.source : this.getProject().getProperty("ant.build.javac.source");
    }

    public void setSource(String v) {
        this.source = v;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setBootclasspath(Path bootclasspath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = bootclasspath;
        } else {
            this.bootclasspath.append(bootclasspath);
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public boolean getDeprecation() {
        return this.deprecation;
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.memoryInitialSize = memoryInitialSize;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.memoryMaximumSize = memoryMaximumSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setDepend(boolean depend) {
        this.depend = depend;
    }

    public boolean getDepend() {
        return this.depend;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setTarget(String target) {
        this.targetAttribute = target;
    }

    public String getTarget() {
        return this.targetAttribute != null ? this.targetAttribute : this.getProject().getProperty("ant.build.javac.target");
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime != null ? this.includeAntRuntime : true;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    public void setExecutable(String forkExec) {
        this.forkedExecutable = forkExec;
    }

    public String getExecutable() {
        return this.forkedExecutable;
    }

    public boolean isForkedJavac() {
        return this.fork || EXTJAVAC.equalsIgnoreCase(this.getCompiler());
    }

    public String getJavacExecutable() {
        if (this.forkedExecutable == null && this.isForkedJavac()) {
            this.forkedExecutable = this.getSystemJavac();
        } else if (this.forkedExecutable != null && !this.isForkedJavac()) {
            this.forkedExecutable = null;
        }
        return this.forkedExecutable;
    }

    public void setNowarn(boolean flag) {
        this.nowarn = flag;
    }

    public boolean getNowarn() {
        return this.nowarn;
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument arg = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(arg);
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCurrentCompilerArgs() {
        String chosen = this.facade.getExplicitChoice();
        try {
            String appliedCompiler = this.getCompiler();
            this.facade.setImplementation(appliedCompiler);
            String[] result = this.facade.getArgs();
            String altCompilerName = this.getAltCompilerName(this.facade.getImplementation());
            if (result.length == 0 && altCompilerName != null) {
                this.facade.setImplementation(altCompilerName);
                result = this.facade.getArgs();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.facade.setImplementation(chosen);
        }
    }

    private String getAltCompilerName(String anImplementation) {
        String nextSelected;
        if (JAVAC19.equalsIgnoreCase(anImplementation) || JAVAC18.equalsIgnoreCase(anImplementation) || JAVAC17.equalsIgnoreCase(anImplementation) || JAVAC16.equalsIgnoreCase(anImplementation) || JAVAC15.equalsIgnoreCase(anImplementation) || JAVAC14.equalsIgnoreCase(anImplementation) || JAVAC13.equalsIgnoreCase(anImplementation)) {
            return MODERN;
        }
        if (JAVAC12.equalsIgnoreCase(anImplementation) || JAVAC11.equalsIgnoreCase(anImplementation)) {
            return CLASSIC;
        }
        if (MODERN.equalsIgnoreCase(anImplementation) && (JAVAC19.equalsIgnoreCase(nextSelected = this.assumedJavaVersion()) || JAVAC18.equalsIgnoreCase(nextSelected) || JAVAC17.equalsIgnoreCase(nextSelected) || JAVAC16.equalsIgnoreCase(nextSelected) || JAVAC15.equalsIgnoreCase(nextSelected) || JAVAC14.equalsIgnoreCase(nextSelected) || JAVAC13.equalsIgnoreCase(nextSelected))) {
            return nextSelected;
        }
        if (CLASSIC.equalsIgnoreCase(anImplementation)) {
            return this.assumedJavaVersion();
        }
        if (EXTJAVAC.equalsIgnoreCase(anImplementation)) {
            return this.assumedJavaVersion();
        }
        return null;
    }

    public void setTempdir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public File getTempdir() {
        return this.tmpDir;
    }

    public void setUpdatedProperty(String updatedProperty) {
        this.updatedProperty = updatedProperty;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    public void setIncludeDestClasses(boolean includeDestClasses) {
        this.includeDestClasses = includeDestClasses;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    public Path createCompilerClasspath() {
        return this.facade.getImplementationClasspath(this.getProject());
    }

    public void add(CompilerAdapter adapter) {
        if (this.nestedAdapter != null) {
            throw new BuildException("Can't have more than one compiler adapter");
        }
        this.nestedAdapter = adapter;
    }

    public void setCreateMissingPackageInfoClass(boolean b) {
        this.createMissingPackageInfoClass = b;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
        if (this.updatedProperty != null && this.taskSuccess && this.compileList.length != 0) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
        this.packageInfos = new HashMap<String, Long>();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        String[] extensions = this.findSupportedFileExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            m.setFrom(extensions[i]);
            m.setTo("*.class");
            SourceFileScanner sfs = new SourceFileScanner(this);
            File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, m);
            if (newFiles.length <= 0) continue;
            this.lookForPackageInfos(srcDir, newFiles);
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    private String[] findSupportedFileExtensions() {
        String compilerImpl = this.getCompiler();
        CompilerAdapter adapter = this.nestedAdapter != null ? this.nestedAdapter : CompilerAdapterFactory.getCompiler(compilerImpl, this, this.createCompilerClasspath());
        String[] extensions = null;
        if (adapter instanceof CompilerAdapterExtension) {
            extensions = ((CompilerAdapterExtension)((Object)adapter)).getSupportedFileExtensions();
        }
        if (extensions == null) {
            extensions = new String[]{"java"};
        }
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].startsWith("*.")) continue;
            extensions[i] = "*." + extensions[i];
        }
        return extensions;
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected boolean isJdkCompiler(String compilerImpl) {
        return MODERN.equals(compilerImpl) || CLASSIC.equals(compilerImpl) || JAVAC19.equals(compilerImpl) || JAVAC18.equals(compilerImpl) || JAVAC17.equals(compilerImpl) || JAVAC16.equals(compilerImpl) || JAVAC15.equals(compilerImpl) || JAVAC14.equals(compilerImpl) || JAVAC13.equals(compilerImpl) || JAVAC12.equals(compilerImpl) || JAVAC11.equals(compilerImpl);
    }

    protected String getSystemJavac() {
        return JavaEnvUtils.getJdkExecutable("javac");
    }

    public void setCompiler(String compiler) {
        this.facade.setImplementation(compiler);
    }

    public String getCompiler() {
        String compilerImpl = this.getCompilerVersion();
        if (this.fork) {
            if (this.isJdkCompiler(compilerImpl)) {
                compilerImpl = EXTJAVAC;
            } else {
                this.log("Since compiler setting isn't classic or modern, ignoring fork setting.", 1);
            }
        }
        return compilerImpl;
    }

    public String getCompilerVersion() {
        this.facade.setMagicValue(this.getProject().getProperty("build.compiler"));
        return this.facade.getImplementation();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
        if (this.includeAntRuntime == null && this.getProject().getProperty("build.sysclasspath") == null) {
            this.log(this.getLocation() + "warning: 'includeantruntime' was not set, " + "defaulting to build.sysclasspath=last; set to false for repeatable builds", 1);
        }
    }

    protected void compile() {
        String compilerImpl = this.getCompiler();
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String filename = this.compileList[i].getAbsolutePath();
                    this.log(filename);
                }
            }
            CompilerAdapter adapter = this.nestedAdapter != null ? this.nestedAdapter : CompilerAdapterFactory.getCompiler(compilerImpl, this, this.createCompilerClasspath());
            adapter.setJavac(this);
            if (adapter.execute()) {
                if (this.createMissingPackageInfoClass) {
                    try {
                        this.generateMissingPackageInfoClasses(this.destDir != null ? this.destDir : this.getProject().resolveFile(this.src.list()[0]));
                    }
                    catch (IOException x) {
                        throw new BuildException(x, this.getLocation());
                    }
                }
            } else {
                this.taskSuccess = false;
                if (this.errorProperty != null) {
                    this.getProject().setNewProperty(this.errorProperty, "true");
                }
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    private void lookForPackageInfos(File srcDir, File[] newFiles) {
        for (int i = 0; i < newFiles.length; ++i) {
            File f = newFiles[i];
            if (!f.getName().equals("package-info.java")) continue;
            String path = FILE_UTILS.removeLeadingPath(srcDir, f).replace(File.separatorChar, '/');
            String suffix = "/package-info.java";
            if (!path.endsWith("/package-info.java")) {
                this.log("anomalous package-info.java path: " + path, 1);
                continue;
            }
            String pkg = path.substring(0, path.length() - "/package-info.java".length());
            this.packageInfos.put(pkg, new Long(f.lastModified()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMissingPackageInfoClasses(File dest) throws IOException {
        for (Map.Entry<String, Long> entry : this.packageInfos.entrySet()) {
            String pkg = entry.getKey();
            Long sourceLastMod = entry.getValue();
            File pkgBinDir = new File(dest, pkg.replace('/', File.separatorChar));
            pkgBinDir.mkdirs();
            File pkgInfoClass = new File(pkgBinDir, "package-info.class");
            if (pkgInfoClass.isFile() && pkgInfoClass.lastModified() >= sourceLastMod) continue;
            this.log("Creating empty " + pkgInfoClass);
            FileOutputStream os = new FileOutputStream(pkgInfoClass);
            try {
                ((OutputStream)os).write(PACKAGE_INFO_CLASS_HEADER);
                byte[] name = pkg.getBytes("UTF-8");
                int length = name.length + 13;
                ((OutputStream)os).write((byte)length / 256);
                ((OutputStream)os).write((byte)length % 256);
                ((OutputStream)os).write(name);
                ((OutputStream)os).write(PACKAGE_INFO_CLASS_FOOTER);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String impl) {
            super.setImplementation(impl);
        }
    }
}

