/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyModule JavaInterfaceTemplate2 = runtime.defineModule("JavaInterfaceTemplate");
        RubyClass singleton = JavaInterfaceTemplate2.getSingletonClass();
        singleton.addReadAttribute(context, "java_class");
        singleton.defineAnnotatedMethods(JavaInterfaceTemplate.class);
        JavaInterfaceTemplate2.defineAnnotatedMethods(JavaProxy.ClassMethods.class);
        return JavaInterfaceTemplate2;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self2, IRubyObject clazz) {
        if (!(clazz instanceof RubyModule)) {
            Ruby runtime = context.runtime;
            throw runtime.newTypeError(clazz, runtime.getModule());
        }
        RubyModule targetModule = (RubyModule)clazz;
        JavaClass javaClass = JavaInterfaceTemplate.getJavaClassForInterface(self2);
        Method[] javaInstanceMethods = javaClass.javaClass().getMethods();
        DummyMethodImpl dummyMethodImpl = new DummyMethodImpl(targetModule);
        for (int i2 = 0; i2 < javaInstanceMethods.length; ++i2) {
            Method javaMethod = javaInstanceMethods[i2];
            String name2 = javaMethod.getName();
            if (!targetModule.searchMethod(name2).isUndefined()) continue;
            targetModule.addMethod(name2, dummyMethodImpl);
        }
        return context.nil;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self2, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self2, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            JavaInterfaceTemplate.appendFeaturesToModule(context, self2, (RubyModule)clazz);
        } else {
            throw context.runtime.newTypeError("received " + clazz + ", expected Class/Module");
        }
        return Helpers.invokeSuper(context, self2, clazz, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self2, RubyClass clazz) {
        Ruby runtime = context.runtime;
        JavaInterfaceTemplate.checkAlreadyReified(clazz, runtime);
        JavaClass javaClass = JavaInterfaceTemplate.getJavaClassForInterface(self2);
        if (!clazz.hasInstanceVariable("@java_interfaces")) {
            RubyArray javaInterfaces = RubyArray.newArray(runtime, javaClass);
            clazz.setInstanceVariable("@java_interfaces", javaInterfaces);
            JavaInterfaceTemplate.initInterfaceImplMethods(context, clazz);
        } else {
            RubyArray javaInterfaces = (RubyArray)clazz.getInstanceVariable("@java_interfaces");
            if (!javaInterfaces.isFrozen() && !javaInterfaces.includes(context, javaClass)) {
                javaInterfaces.append(javaClass);
            }
        }
    }

    private static void checkAlreadyReified(RubyClass clazz, Ruby runtime) throws RaiseException {
        if (Java.NEW_STYLE_EXTENSION && clazz.getReifiedClass() != null || clazz.hasInstanceVariable("@java_class") && clazz.getInstanceVariable("@java_class").isTrue() && !clazz.getSingletonClass().isMethodBound("java_proxy_class", false) || clazz.hasInstanceVariable("@java_proxy_class") && clazz.getInstanceVariable("@java_proxy_class").isTrue()) {
            throw runtime.newArgumentError("can not add Java interface to existing Java class");
        }
    }

    private static void initInterfaceImplMethods(ThreadContext context, RubyClass clazz) {
        RubyClass singleton;
        if (!clazz.isMethodBound("__jcreate!", false) && !clazz.isMethodBound("__jcreate_meta!", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addReadAttribute(context, "java_interfaces");
            if (!Java.NEW_STYLE_EXTENSION && clazz.getSuperClass().getRealClass().hasInstanceVariable("@java_class") || RubyInstanceConfig.INTERFACES_USE_PROXY) {
                final ObjectAllocator proxyAllocator = clazz.getAllocator();
                clazz.setAllocator(new ObjectAllocator(){

                    @Override
                    public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                        IRubyObject newObj = proxyAllocator.allocate(runtime, klazz);
                        Helpers.invoke(runtime.getCurrentContext(), newObj, "__jcreate!");
                        return newObj;
                    }
                });
                clazz.addMethod("__jcreate!", new InterfaceProxyFactory(clazz));
            } else {
                JavaInterfaceTemplate.addRealImplClassNew(clazz);
            }
            clazz.addMethod("__jcreate_meta!", new InterfaceProxyFactory(clazz));
            clazz.addMethod("java_class", new JavaClassAccessor(clazz));
            if (!clazz.searchMethod("===").isUndefined()) {
                clazz.defineAlias("old_eqq", "===");
                clazz.addMethod("===", new JavaMethod.JavaMethodOne(clazz, Visibility.PUBLIC){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                        if (arg2.respondsTo("java_object")) {
                            IRubyObject interfaces2 = self2.getMetaClass().getInstanceVariables().getInstanceVariable("@java_interfaces");
                            assert (interfaces2 instanceof RubyArray) : "interface list was not an array";
                            return context.runtime.newBoolean(((RubyArray)interfaces2).op_diff(((JavaObject)arg2.dataGetStruct()).java_class().interfaces()).equals(RubyArray.newArray(context.runtime)));
                        }
                        return Helpers.invoke(context, self2, "old_eqq", arg2);
                    }
                });
            }
        }
        if (!clazz.isMethodBound("implement", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addMethod("implement", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject iface) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces != null && ifaces.includes(context, iface)) {
                        return Helpers.invoke(context, iface, "implement", self2);
                    }
                    return context.nil;
                }
            });
            singleton.addMethod("implement_all", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces == null) {
                        return context.nil;
                    }
                    for (int i2 = 0; i2 < ifaces.size(); ++i2) {
                        RubyModule iface = Java.get_interface_module(context.runtime, ifaces.eltInternal(i2));
                        Helpers.invoke(context, (IRubyObject)iface, "implement", self2);
                    }
                    return ifaces;
                }
            });
        }
    }

    public static void addRealImplClassNew(RubyClass clazz) {
        clazz.setAllocator(new ObjectAllocator(){
            private Constructor proxyConstructor;

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                Class reifiedClass = klazz.getReifiedClass();
                if (this.proxyConstructor == null || this.proxyConstructor.getDeclaringClass() != reifiedClass) {
                    if (reifiedClass == null) {
                        reifiedClass = Java.generateRealClass(klazz);
                    }
                    this.proxyConstructor = Java.getRealClassConstructor(runtime, reifiedClass);
                }
                IRubyObject newObj = Java.constructProxy(runtime, this.proxyConstructor, klazz);
                return newObj;
            }
        });
    }

    private static IRubyObject newInterfaceProxy(IRubyObject self2) {
        RubyClass current2 = self2.getMetaClass();
        IRubyObject newObject2 = Java.newInterfaceImpl(self2, Java.getInterfacesFromRubyClass(current2));
        JavaUtilities.set_java_object(self2, self2, newObject2);
        return newObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self2, RubyModule module) {
        Ruby runtime = context.runtime;
        if (module.getInstanceVariables().hasInstanceVariable("@java_class") && module.getInstanceVariables().getInstanceVariable("@java_class").isTrue()) {
            throw runtime.newTypeError("can not add Java interface to existing Java interface");
        }
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (JavaInterfaceTemplate.initInterfaceModules(self2, module)) {
                RubyClass singleton = module.getSingletonClass();
                singleton.addMethod("append_features", new AppendFeatures(singleton));
            } else {
                RubyArray interfaceModules = JavaInterfaceTemplate.getInterfaceModules(module);
                if (!interfaceModules.includes(context, self2)) {
                    interfaceModules.append(self2);
                }
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self2, IRubyObject object) {
        if (!(self2 instanceof RubyModule)) {
            throw context.runtime.newTypeError(self2, context.runtime.getModule());
        }
        RubyClass singleton = object.getSingletonClass();
        singleton.include(new IRubyObject[]{self2});
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return JavaProxy.op_aref(context, self2, args2);
    }

    @JRubyMethod(name={"impl"}, rest=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block implBlock) {
        Object[] methodNames;
        Ruby runtime = context.runtime;
        if (!implBlock.isGiven()) {
            throw runtime.newArgumentError("block required to call #impl on a Java interface");
        }
        if (args2.length == 0) {
            methodNames = null;
        } else {
            methodNames = (IRubyObject[])args2.clone();
            Arrays.sort(methodNames);
        }
        RubyClass implClass = RubyClass.newClass(runtime, runtime.getObject());
        implClass.include(new IRubyObject[]{self2});
        IRubyObject implObject = implClass.callMethod(context, "new");
        implClass.addMethod("method_missing", new BlockInterfaceImpl(implClass, implBlock, (IRubyObject[])methodNames));
        return implObject;
    }

    @JRubyMethod(name={"new"}, rest=true)
    public static IRubyObject new_impl(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass implClass = (RubyClass)self2.getInstanceVariables().getInstanceVariable("@__implementation");
        if (implClass == null) {
            implClass = RubyClass.newClass(runtime, runtime.getClass("InterfaceJavaProxy"));
            implClass.include(new IRubyObject[]{self2});
            Helpers.setInstanceVariable(implClass, self2, "@__implementation");
        }
        return Helpers.invoke(context, (IRubyObject)implClass, "new", args2, block);
    }

    private static JavaClass getJavaClassForInterface(IRubyObject module) {
        return (JavaClass)module.getInstanceVariables().getInstanceVariable("@java_class");
    }

    private static RubyArray getJavaInterfaces(IRubyObject module) {
        return (RubyArray)module.getInstanceVariables().getInstanceVariable("@java_interfaces");
    }

    private static RubyArray getInterfaceModules(IRubyObject module) {
        return (RubyArray)module.getInstanceVariables().getInstanceVariable("@java_interface_mods");
    }

    private static boolean initInterfaceModules(IRubyObject self2, IRubyObject module) {
        if (!module.getInstanceVariables().hasInstanceVariable("@java_interface_mods")) {
            RubyArray interfaceMods = RubyArray.newArray(self2.getRuntime(), self2);
            module.getInstanceVariables().setInstanceVariable("@java_interface_mods", interfaceMods);
            return true;
        }
        return false;
    }

    private static class BlockInterfaceImpl
    extends JavaMethod {
        private final IRubyObject[] methodNames;
        private final Block implBlock;

        BlockInterfaceImpl(RubyClass implClass, Block implBlock, IRubyObject[] methodNames) {
            super(implClass, Visibility.PUBLIC);
            this.implBlock = implBlock;
            this.methodNames = methodNames;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2.length, 1, -1);
            return this.callImpl(context, clazz, block, args2);
        }

        private IRubyObject callImpl(ThreadContext context, RubyModule clazz, Block block, IRubyObject ... args2) {
            if (this.methodNames == null) {
                return this.implBlock.call(context, args2);
            }
            if (this.methodNames.length == 1 ? this.methodNames[0].equals(args2[0]) : Arrays.binarySearch(this.methodNames, args2[0]) >= 0) {
                return this.implBlock.call(context, args2);
            }
            return clazz.getSuperClass().callMethod(context, "method_missing", args2, block);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
            return this.callImpl(context, klazz, block, arg0);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1, arg2);
        }
    }

    private static class AppendFeatures
    extends JavaMethod.JavaMethodOneBlock {
        AppendFeatures(RubyModule singletonClass) {
            super(singletonClass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
            if (!(arg2 instanceof RubyModule)) {
                throw context.runtime.newTypeError("append_features called with non-module");
            }
            RubyModule target = (RubyModule)arg2;
            target.include(JavaInterfaceTemplate.getInterfaceModules(self2).toJavaArray());
            return Helpers.invokeAs(context, clazz.getSuperClass(), self2, name2, arg2, block);
        }
    }

    private static class JavaClassAccessor
    extends JavaMethod.JavaMethodZero {
        JavaClassAccessor(RubyClass klass) {
            super(klass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            Object wrapped = self2.dataGetStruct();
            Class<?> javaClass = wrapped != null ? ((JavaObject)wrapped).getJavaClass() : self2.getClass();
            return JavaClass.get(context.runtime, javaClass);
        }
    }

    private static class InterfaceProxyFactory
    extends JavaMethod.JavaMethodN {
        InterfaceProxyFactory(RubyClass clazz) {
            super(clazz, Visibility.PRIVATE);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            return JavaInterfaceTemplate.newInterfaceProxy(self2);
        }
    }

    private static class DummyMethodImpl
    extends JavaMethod {
        DummyMethodImpl(RubyModule targetModule) {
            super(targetModule, Visibility.PUBLIC);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return context.nil;
        }
    }
}

