/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.rendering;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sejda.sambox.pdmodel.font.PDSimpleFont;
import org.sejda.sambox.rendering.Glyph2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Type1Glyph2D
implements Glyph2D {
    private static final Logger LOG = LoggerFactory.getLogger(Type1Glyph2D.class);
    private final Map<Integer, GeneralPath> cache = new HashMap<Integer, GeneralPath>();
    private final PDSimpleFont font;

    Type1Glyph2D(PDSimpleFont font) {
        this.font = font;
    }

    @Override
    public GeneralPath getPathForCharacterCode(int code) {
        GeneralPath path = this.cache.get(code);
        if (path == null) {
            try {
                String name = this.font.getEncoding().getName(code);
                if (!this.font.hasGlyph(name)) {
                    LOG.warn("No glyph for " + code + " (" + name + ") in font " + this.font.getName());
                }
                if ((path = this.font.getPath(name)) == null) {
                    path = this.font.getPath(".notdef");
                }
                this.cache.put(code, path);
                return path;
            }
            catch (IOException e) {
                LOG.error("Glyph rendering failed", e);
                path = new GeneralPath();
            }
        }
        return path;
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

