# -*- coding: utf-8 -*-

# Copyright (C) 2007-2008 by Igor Novikov
#
# This library is covered by GNU General Public License v2.0.
# For more info see COPYRIGHTS file in sK1 root directory.
###Sketch Config
#type = Export
#tk_file_type = ("PostScript (PS)", '.ps')
#extensions = '.ps'
#format_name = 'PS'
#unload = 1
###End

import app
from uc.utils import system
from app import PostScriptDevice


def save(doc, file, filename, options = {}):
	app.updateInfo(inf1=_('Postscript generation.'),inf2=_('Start document composing'),inf3=3)
	
	bbox = doc.BoundingRect(visible = 0, printable = 1)
	dev = PostScriptDevice
	ps_dev = dev(file, as_eps = 1, bounding_box = tuple(bbox),
					rotate = 0, # page rotate?
					For = system.get_real_username(),
					CreationDate = system.current_date(), Title = 'generated by sK1',
					document = doc)
	doc.Draw(ps_dev)
	ps_dev.Close()
	
	app.updateInfo(inf2=_('Document generation is finished'),inf3=100)
