#ifndef EFL_GENERATED_ELDBUS_MODEL_CONNECTION_HH
#define EFL_GENERATED_ELDBUS_MODEL_CONNECTION_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "eldbus_model_connection.eo.h"
}

#include "eo_base.eo.hh"
#include "efl_model_base.eo.hh"
#include <string>

namespace eldbus {

struct model_connection;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace eldbus {

struct model_connection
{
   int type_get() const;

   void type_set(int value_) const;

   ::efl::eina::string_view address_get() const;

   void address_set(::efl::eina::string_view value_) const;

   bool private_get() const;

   void private_set(bool value_) const;



   static Eo_Class const* _eo_class()
   {
      return(ELDBUS_MODEL_CONNECTION_CLASS);
   }

   operator ::eldbus::model_connection() const;
   operator ::eldbus::model_connection&();
   operator ::eldbus::model_connection const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::eldbus::model_connection*() const { return static_cast<::eldbus::model_connection*>(static_cast<D const*>(this)->p); }
      operator ::eldbus::model_connection const*() const { return static_cast<::eldbus::model_connection const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::eldbus::model_connection const*() const { return static_cast<::eldbus::model_connection const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace eldbus {

/// @brief Class model_connection
struct model_connection
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::model::base)
      , EO_CXX_INHERIT(eo::base)
{
   /// @cond LOCAL
   struct _c_constructor
   {

      explicit _c_constructor(int type_, ::efl::eina::string_view address_, bool private__)
         : type_(type_), address_(address_), private__(private__)
      {}
      void operator()()
      {
         ::eldbus_model_connection_constructor(type_, ::efl::eolian::to_c(address_), ::efl::eolian::to_c(private__));
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      int type_;
      ::efl::eina::string_view address_;
      bool private__;
   };
   /// @endcond

   //@{
   /**
      @brief Constructs a new eldbus::model_connection object.

      Constructs a new eldbus::model_connection object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Since this class have a necessary constructor method, you must call it
      in the right place within this constructor parameters.

      Example:
      @code
      eldbus::model_connection my_model_connection(efl::eo::parent = parent_object,
         my_model_connection.constructor(type_, address_, private__));
      @endcode

      @see model_connection::constructor
      @see model_connection(Eo* eo)
   */
   explicit model_connection(::efl::eo::parent_type _p, _c_constructor _c0)
      : model_connection(_ctors_call(_p, _c0))
   {}

   explicit model_connection(_c_constructor _c0)
      : model_connection(_ctors_call(::efl::eo::parent = nullptr, _c0))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit model_connection(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit model_connection(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   model_connection(model_connection const& other)
      : model_connection(eo_ref(other._eo_ptr()))
   {}

   ~model_connection() {}

   /// @param type 
   /// @param address 
   /// @param private_ 
   ///
   static _c_constructor constructor(int type_, ::efl::eina::string_view address_, bool private__);

   int type_get() const;

   void type_set(int value_) const;

   ::efl::eina::string_view address_get() const;

   void address_set(::efl::eina::string_view value_) const;

   bool private_get() const;

   void private_set(bool value_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_child_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILD_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EFL_MODEL_BASE_EVENT_CHILD_ADDED );
   }

   template <typename T>
   void
   callback_child_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILD_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_child_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILD_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EFL_MODEL_BASE_EVENT_CHILD_REMOVED );
   }

   template <typename T>
   void
   callback_child_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILD_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_count_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED );
   }

   template <typename T>
   void
   callback_children_count_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_CHILDREN_COUNT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_load_status_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_LOAD_STATUS, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EFL_MODEL_BASE_EVENT_LOAD_STATUS );
   }

   template <typename T>
   void
   callback_load_status_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_LOAD_STATUS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_properties_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::eldbus::model_connection, function_type>,
         EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED );
   }

   template <typename T>
   void
   callback_properties_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_MODEL_BASE_EVENT_PROPERTIES_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELDBUS_MODEL_CONNECTION_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::eldbus::model_connection::address_of<address_of>
      , ::eo_cxx::efl::model::base::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::eldbus::model_connection* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::eldbus::model_connection::address_const_of<address_const_of>
      , ::eo_cxx::efl::model::base::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::eldbus::model_connection const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p, _c_constructor _c0)
   {
      Eo* _ret_eo = eo_add_ref(ELDBUS_MODEL_CONNECTION_CLASS, _p._eo_raw, _c0());

      _c0.register_ev_del_free_callback(_ret_eo);
      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::eldbus::model_connection) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::eldbus::model_connection>::value, "");

}


#include "eldbus_model_connection.eo.impl.hh"

#endif // EFL_GENERATED_ELDBUS_MODEL_CONNECTION_HH

