/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

class MemoryCache {
    private static final int BUFFER_LENGTH = 8192;
    private ArrayList cache = new ArrayList();
    private long cacheStart = 0L;
    private long length = 0L;

    MemoryCache() {
    }

    private byte[] getCacheBlock(long blockNum) throws IOException {
        long blockOffset = blockNum - this.cacheStart;
        if (blockOffset > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return (byte[])this.cache.get((int)blockOffset);
    }

    public long loadFromStream(InputStream stream, long pos) throws IOException {
        if (pos < this.length) {
            return pos;
        }
        int offset = (int)(this.length % 8192L);
        byte[] buf = null;
        long len = pos - this.length;
        if (offset != 0) {
            buf = this.getCacheBlock(this.length / 8192L);
        }
        while (len > 0L) {
            if (buf == null) {
                try {
                    buf = new byte[8192];
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("No memory left for cache!");
                }
                offset = 0;
            }
            int left = 8192 - offset;
            int nbytes = (int)Math.min(len, (long)left);
            if ((nbytes = stream.read(buf, offset, nbytes)) == -1) {
                return this.length;
            }
            if (offset == 0) {
                this.cache.add(buf);
            }
            len -= (long)nbytes;
            this.length += (long)nbytes;
            if ((offset += nbytes) < 8192) continue;
            buf = null;
        }
        return pos;
    }

    public void writeToStream(OutputStream stream, long pos, long len) throws IOException {
        if (pos + len > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (pos < 0L || len < 0L) {
            throw new IndexOutOfBoundsException("Negative pos or len");
        }
        if (len == 0L) {
            return;
        }
        long bufIndex = pos / 8192L;
        if (bufIndex < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        int offset = (int)(pos % 8192L);
        byte[] buf = this.getCacheBlock(bufIndex++);
        while (len > 0L) {
            if (buf == null) {
                buf = this.getCacheBlock(bufIndex++);
                offset = 0;
            }
            int nbytes = (int)Math.min(len, (long)(8192 - offset));
            stream.write(buf, offset, nbytes);
            buf = null;
            len -= (long)nbytes;
        }
    }

    private void pad(long pos) throws IOException {
        long currIndex = this.cacheStart + (long)this.cache.size() - 1L;
        long lastIndex = pos / 8192L;
        long numNewBuffers = lastIndex - currIndex;
        for (long i = 0L; i < numNewBuffers; ++i) {
            try {
                this.cache.add(new byte[8192]);
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new IOException("No memory left for cache!");
            }
        }
    }

    public void write(byte[] b, int off, int len, long pos) throws IOException {
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || pos < 0L || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        long lastPos = pos + (long)len - 1L;
        if (lastPos >= this.length) {
            this.pad(lastPos);
            this.length = lastPos + 1L;
        }
        int offset = (int)(pos % 8192L);
        while (len > 0) {
            byte[] buf = this.getCacheBlock(pos / 8192L);
            int nbytes = Math.min(len, 8192 - offset);
            System.arraycopy(b, off, buf, offset, nbytes);
            pos += (long)nbytes;
            off += nbytes;
            len -= nbytes;
            offset = 0;
        }
    }

    public void write(int b, long pos) throws IOException {
        if (pos < 0L) {
            throw new ArrayIndexOutOfBoundsException("pos < 0");
        }
        if (pos >= this.length) {
            this.pad(pos);
            this.length = pos + 1L;
        }
        byte[] buf = this.getCacheBlock(pos / 8192L);
        int offset = (int)(pos % 8192L);
        buf[offset] = (byte)b;
    }

    public long getLength() {
        return this.length;
    }

    public int read(long pos) throws IOException {
        if (pos >= this.length) {
            return -1;
        }
        byte[] buf = this.getCacheBlock(pos / 8192L);
        if (buf == null) {
            return -1;
        }
        return buf[(int)(pos % 8192L)] & 0xFF;
    }

    public void read(byte[] b, int off, int len, long pos) throws IOException {
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || pos < 0L || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pos + (long)len > this.length) {
            throw new IndexOutOfBoundsException();
        }
        long index = pos / 8192L;
        int offset = (int)pos % 8192;
        while (len > 0) {
            int nbytes = Math.min(len, 8192 - offset);
            byte[] buf = this.getCacheBlock(index++);
            System.arraycopy(buf, offset, b, off, nbytes);
            len -= nbytes;
            off += nbytes;
            offset = 0;
        }
    }

    public void disposeBefore(long pos) {
        long index = pos / 8192L;
        if (index < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        long numBlocks = Math.min(index - this.cacheStart, (long)this.cache.size());
        for (long i = 0L; i < numBlocks; ++i) {
            this.cache.remove(0);
        }
        this.cacheStart = index;
    }

    public void reset() {
        this.cache.clear();
        this.cacheStart = 0L;
        this.length = 0L;
    }
}

