/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.net.URL;
import sun.net.ProgressMonitor;

public class ProgressSource {
    private URL url;
    private String method;
    private String contentType;
    private long progress = 0L;
    private long lastProgress = 0L;
    private long expected = -1L;
    private State state;
    private boolean connected = false;
    private int threshold = 8192;
    private ProgressMonitor progressMonitor;

    public ProgressSource(URL url, String method) {
        this(url, method, -1L);
    }

    public ProgressSource(URL url, String method, long expected) {
        this.url = url;
        this.method = method;
        this.contentType = "content/unknown";
        this.progress = 0L;
        this.lastProgress = 0L;
        this.expected = expected;
        this.state = State.NEW;
        this.progressMonitor = ProgressMonitor.getDefault();
        this.threshold = this.progressMonitor.getProgressUpdateThreshold();
    }

    public boolean connected() {
        if (!this.connected) {
            this.connected = true;
            this.state = State.CONNECTED;
            return false;
        }
        return true;
    }

    public void close() {
        this.state = State.DELETE;
    }

    public URL getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getExpected() {
        return this.expected;
    }

    public State getState() {
        return this.state;
    }

    public void beginTracking() {
        this.progressMonitor.registerSource(this);
    }

    public void finishTracking() {
        this.progressMonitor.unregisterSource(this);
    }

    public void updateProgress(long latestProgress, long expectedProgress) {
        this.lastProgress = this.progress;
        this.progress = latestProgress;
        this.expected = expectedProgress;
        this.state = !this.connected() ? State.CONNECTED : State.UPDATE;
        if (this.lastProgress / (long)this.threshold != this.progress / (long)this.threshold) {
            this.progressMonitor.updateProgress(this);
        }
        if (this.expected != -1L && this.progress >= this.expected && this.progress != 0L) {
            this.close();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getClass().getName() + "[url=" + this.url + ", method=" + this.method + ", state=" + (Object)((Object)this.state) + ", content-type=" + this.contentType + ", progress=" + this.progress + ", expected=" + this.expected + "]";
    }

    public static enum State {
        NEW,
        CONNECTED,
        UPDATE,
        DELETE;

    }
}

