/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;

public class PendingClusterTasksResponse
extends ActionResponse
implements Iterable<PendingClusterTask>,
ToXContent {
    private List<PendingClusterTask> pendingTasks;

    PendingClusterTasksResponse() {
    }

    PendingClusterTasksResponse(List<PendingClusterTask> pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public List<PendingClusterTask> pendingTasks() {
        return this.pendingTasks;
    }

    public List<PendingClusterTask> getPendingTasks() {
        return this.pendingTasks();
    }

    @Override
    public Iterator<PendingClusterTask> iterator() {
        return this.pendingTasks.iterator();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("tasks: (").append(this.pendingTasks.size()).append("):\n");
        for (PendingClusterTask pendingClusterTask : this) {
            sb.append(pendingClusterTask.getInsertOrder()).append("/").append(pendingClusterTask.getPriority()).append("/").append(pendingClusterTask.getSource()).append("/").append(pendingClusterTask.getTimeInQueue()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.TASKS);
        for (PendingClusterTask pendingClusterTask : this) {
            builder.startObject();
            builder.field(Fields.INSERT_ORDER, pendingClusterTask.getInsertOrder());
            builder.field(Fields.PRIORITY, (Object)pendingClusterTask.getPriority());
            builder.field(Fields.SOURCE, pendingClusterTask.getSource());
            builder.field(Fields.EXECUTING, pendingClusterTask.isExecuting());
            builder.field(Fields.TIME_IN_QUEUE_MILLIS, pendingClusterTask.getTimeInQueueInMillis());
            builder.field(Fields.TIME_IN_QUEUE, (Object)pendingClusterTask.getTimeInQueue());
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.pendingTasks = new ArrayList<PendingClusterTask>(size);
        for (int i = 0; i < size; ++i) {
            PendingClusterTask task = new PendingClusterTask();
            task.readFrom(in);
            this.pendingTasks.add(task);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.pendingTasks.size());
        for (PendingClusterTask task : this.pendingTasks) {
            task.writeTo(out);
        }
    }

    static final class Fields {
        static final XContentBuilderString TASKS = new XContentBuilderString("tasks");
        static final XContentBuilderString EXECUTING = new XContentBuilderString("executing");
        static final XContentBuilderString INSERT_ORDER = new XContentBuilderString("insert_order");
        static final XContentBuilderString PRIORITY = new XContentBuilderString("priority");
        static final XContentBuilderString SOURCE = new XContentBuilderString("source");
        static final XContentBuilderString TIME_IN_QUEUE_MILLIS = new XContentBuilderString("time_in_queue_millis");
        static final XContentBuilderString TIME_IN_QUEUE = new XContentBuilderString("time_in_queue");

        Fields() {
        }
    }
}

