/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class ExplainRequest
extends SingleShardRequest<ExplainRequest> {
    private String type = "_all";
    private String id;
    private String routing;
    private String preference;
    private BytesReference source;
    private String[] fields;
    private FetchSourceContext fetchSourceContext;
    private String[] filteringAlias = Strings.EMPTY_ARRAY;
    long nowInMillis;

    public ExplainRequest() {
    }

    public ExplainRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public String type() {
        return this.type;
    }

    public ExplainRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExplainRequest id(String id) {
        this.id = id;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ExplainRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ExplainRequest parent(String parent) {
        this.routing = parent;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public ExplainRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public ExplainRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public ExplainRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public ExplainRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public String[] fields() {
        return this.fields;
    }

    public ExplainRequest fields(String[] fields) {
        this.fields = fields;
        return this;
    }

    public String[] filteringAlias() {
        return this.filteringAlias;
    }

    public ExplainRequest filteringAlias(String[] filteringAlias) {
        if (filteringAlias != null) {
            this.filteringAlias = filteringAlias;
        }
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.source = in.readBytesReference();
        this.filteringAlias = in.readStringArray();
        if (in.readBoolean()) {
            this.fields = in.readStringArray();
        }
        this.fetchSourceContext = FetchSourceContext.optionalReadFromStream(in);
        this.nowInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        out.writeStringArray(this.filteringAlias);
        if (this.fields != null) {
            out.writeBoolean(true);
            out.writeStringArray(this.fields);
        } else {
            out.writeBoolean(false);
        }
        FetchSourceContext.optionalWriteToStream(this.fetchSourceContext, out);
        out.writeVLong(this.nowInMillis);
    }
}

