/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.google.common.base.Preconditions;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty.NettyHttpServerTransport;

public class HttpServerModule
extends AbstractModule {
    private final Settings settings;
    private final ESLogger logger;
    private Class<? extends HttpServerTransport> httpServerTransportClass;

    public HttpServerModule(Settings settings) {
        this.settings = settings;
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.httpServerTransportClass = NettyHttpServerTransport.class;
    }

    @Override
    protected void configure() {
        this.bind(HttpServerTransport.class).to(this.httpServerTransportClass).asEagerSingleton();
        this.bind(HttpServer.class).asEagerSingleton();
    }

    public void setHttpServerTransport(Class<? extends HttpServerTransport> httpServerTransport, String source) {
        Preconditions.checkNotNull(httpServerTransport, (Object)"Configured http server transport may not be null");
        Preconditions.checkNotNull((Object)source, (Object)"Plugin, that changes transport may not be null");
        this.logger.info("Using [{}] as http transport, overridden by [{}]", this.httpServerTransportClass.getName(), source);
        this.httpServerTransportClass = httpServerTransport;
    }
}

