/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;

public class CustomFieldsVisitor
extends FieldsVisitor {
    private final Set<String> fields;
    private final List<String> patterns;

    public CustomFieldsVisitor(Set<String> fields, List<String> patterns, boolean loadSource) {
        super(loadSource);
        this.fields = fields;
        this.patterns = patterns;
    }

    public CustomFieldsVisitor(Set<String> fields, boolean loadSource) {
        this(fields, Collections.emptyList(), loadSource);
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (super.needsField(fieldInfo) == StoredFieldVisitor.Status.YES) {
            return StoredFieldVisitor.Status.YES;
        }
        if (this.fields.contains(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        for (String pattern : this.patterns) {
            if (!Regex.simpleMatch(pattern, fieldInfo.name)) continue;
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }
}

