/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

@Deprecated
public class OrQueryParser
implements QueryParser {
    public static final String NAME = "or";
    private final DeprecationLogger deprecationLogger;

    @Inject
    public OrQueryParser() {
        ESLogger logger = Loggers.getLogger(this.getClass());
        this.deprecationLogger = new DeprecationLogger(logger);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query filter;
        this.deprecationLogger.deprecated("The [or] query is deprecated, please use a [bool] query instead with [should] clauses.", new Object[0]);
        XContentParser parser = parseContext.parser();
        ArrayList<Query> queries = new ArrayList<Query>();
        boolean queriesFound = false;
        String queryName = null;
        String currentFieldName = null;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                queriesFound = true;
                filter = parseContext.parseInnerFilter();
                if (filter == null) continue;
                queries.add(filter);
            }
        } else {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("filters".equals(currentFieldName)) {
                        queriesFound = true;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            filter = parseContext.parseInnerFilter();
                            if (filter == null) continue;
                            queries.add(filter);
                        }
                        continue;
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        queriesFound = true;
                        filter = parseContext.parseInnerFilter();
                        if (filter == null) continue;
                        queries.add(filter);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[or] query does not support [" + currentFieldName + "]", new Object[0]);
            }
        }
        if (!queriesFound) {
            throw new QueryParsingException(parseContext, "[or] query requires 'filters' to be set on it'", new Object[0]);
        }
        if (queries.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (Query f : queries) {
            queryBuilder.add(f, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery query = queryBuilder.build();
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)query);
        }
        return query;
    }
}

