/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.index.query.support.QueryParsers;

public class RegexpQueryParser
implements QueryParser {
    public static final String NAME = "regexp";
    public static final int DEFAULT_FLAGS_VALUE = RegexpFlag.ALL.value();
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of regexp query");

    @Inject
    public RegexpQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = parser.currentName();
        String rewriteMethod = null;
        String value = null;
        float boost = 1.0f;
        int flagsValue = DEFAULT_FLAGS_VALUE;
        int maxDeterminizedStates = 10000;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName)) {
                        value = parser.textOrNull();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if ("rewrite".equals(currentFieldName)) {
                        rewriteMethod = parser.textOrNull();
                        continue;
                    }
                    if ("flags".equals(currentFieldName)) {
                        String flags = parser.textOrNull();
                        flagsValue = RegexpFlag.resolveValue(flags);
                        continue;
                    }
                    if ("max_determinized_states".equals(currentFieldName)) {
                        maxDeterminizedStates = parser.intValue();
                        continue;
                    }
                    if ("flags_value".equals(currentFieldName)) {
                        flagsValue = parser.intValue();
                        continue;
                    }
                    if ("_name".equals(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[regexp] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            fieldName = currentFieldName;
            value = parser.textOrNull();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "No value specified for regexp query", new Object[0]);
        }
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(parseContext.parseFieldMatcher(), rewriteMethod, null);
        Query query = null;
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType != null) {
            query = fieldType.regexpQuery(value, flagsValue, maxDeterminizedStates, method, parseContext);
        }
        if (query == null) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(fieldName, BytesRefs.toBytesRef(value)), flagsValue, maxDeterminizedStates);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query = regexpQuery;
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

