/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public abstract class BaseInnerHitBuilder<T extends BaseInnerHitBuilder>
implements ToXContent {
    protected SearchSourceBuilder sourceBuilder;

    public T setFrom(int from) {
        this.sourceBuilder().from(from);
        return (T)this;
    }

    public T setSize(int size) {
        this.sourceBuilder().size(size);
        return (T)this;
    }

    public T setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return (T)this;
    }

    public T setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return (T)this;
    }

    public T setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return (T)this;
    }

    public T field(String name) {
        this.sourceBuilder().field(name);
        return (T)this;
    }

    public T setNoFields() {
        this.sourceBuilder().noFields();
        return (T)this;
    }

    public T setFetchSource(boolean fetch) {
        this.sourceBuilder().fetchSource(fetch);
        return (T)this;
    }

    public T setFetchSource(@Nullable String include, @Nullable String exclude) {
        this.sourceBuilder().fetchSource(include, exclude);
        return (T)this;
    }

    public T setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().fetchSource(includes, excludes);
        return (T)this;
    }

    public T addFieldDataField(String name) {
        this.sourceBuilder().fieldDataField(name);
        return (T)this;
    }

    public T addScriptField(String name, Script script) {
        this.sourceBuilder().scriptField(name, script);
        return (T)this;
    }

    public T addSort(String field, SortOrder order) {
        this.sourceBuilder().sort(field, order);
        return (T)this;
    }

    public T addSort(SortBuilder sort) {
        this.sourceBuilder().sort(sort);
        return (T)this;
    }

    public HighlightBuilder highlightBuilder() {
        return this.sourceBuilder().highlighter();
    }

    public T addHighlightedField(String name) {
        this.highlightBuilder().field(name);
        return (T)this;
    }

    public T addHighlightedField(String name, int fragmentSize) {
        this.highlightBuilder().field(name, fragmentSize);
        return (T)this;
    }

    public T addHighlightedField(String name, int fragmentSize, int numberOfFragments) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments);
        return (T)this;
    }

    public T addHighlightedField(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments, fragmentOffset);
        return (T)this;
    }

    public T addHighlightedField(HighlightBuilder.Field field) {
        this.highlightBuilder().field(field);
        return (T)this;
    }

    public T setHighlighterTagsSchema(String schemaName) {
        this.highlightBuilder().tagsSchema(schemaName);
        return (T)this;
    }

    public T setHighlighterFragmentSize(Integer fragmentSize) {
        this.highlightBuilder().fragmentSize(fragmentSize);
        return (T)this;
    }

    public T setHighlighterNumOfFragments(Integer numOfFragments) {
        this.highlightBuilder().numOfFragments(numOfFragments);
        return (T)this;
    }

    public T setHighlighterFilter(Boolean highlightFilter) {
        this.highlightBuilder().highlightFilter(highlightFilter);
        return (T)this;
    }

    public T setHighlighterEncoder(String encoder) {
        this.highlightBuilder().encoder(encoder);
        return (T)this;
    }

    public T setHighlighterPreTags(String ... preTags) {
        this.highlightBuilder().preTags(preTags);
        return (T)this;
    }

    public T setHighlighterPostTags(String ... postTags) {
        this.highlightBuilder().postTags(postTags);
        return (T)this;
    }

    public T setHighlighterOrder(String order) {
        this.highlightBuilder().order(order);
        return (T)this;
    }

    public T setHighlighterRequireFieldMatch(boolean requireFieldMatch) {
        this.highlightBuilder().requireFieldMatch(requireFieldMatch);
        return (T)this;
    }

    public T setHighlighterBoundaryMaxScan(Integer boundaryMaxScan) {
        this.highlightBuilder().boundaryMaxScan(boundaryMaxScan);
        return (T)this;
    }

    public T setHighlighterBoundaryChars(char[] boundaryChars) {
        this.highlightBuilder().boundaryChars(boundaryChars);
        return (T)this;
    }

    public T setHighlighterType(String type) {
        this.highlightBuilder().highlighterType(type);
        return (T)this;
    }

    public T setHighlighterFragmenter(String fragmenter) {
        this.highlightBuilder().fragmenter(fragmenter);
        return (T)this;
    }

    public T setHighlighterQuery(QueryBuilder highlightQuery) {
        this.highlightBuilder().highlightQuery(highlightQuery);
        return (T)this;
    }

    public T setHighlighterNoMatchSize(Integer noMatchSize) {
        this.highlightBuilder().noMatchSize(noMatchSize);
        return (T)this;
    }

    public T setHighlighterPhraseLimit(Integer phraseLimit) {
        this.highlightBuilder().phraseLimit(phraseLimit);
        return (T)this;
    }

    public T setHighlighterOptions(Map<String, Object> options) {
        this.highlightBuilder().options(options);
        return (T)this;
    }

    protected SearchSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new SearchSourceBuilder();
        }
        return this.sourceBuilder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.sourceBuilder != null) {
            this.sourceBuilder.innerToXContent(builder, params);
        }
        return builder;
    }
}

