/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.internal.SearchContext;

public abstract class BucketMetricsParser
implements PipelineAggregator.Parser {
    public static final ParseField FORMAT = new ParseField("format", new String[0]);

    @Override
    public final PipelineAggregatorFactory parse(String pipelineAggregatorName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
        HashMap<String, Object> leftover = new HashMap<String, Object>(5);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (context.parseFieldMatcher().match(currentFieldName, FORMAT)) {
                    format = parser.text();
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, GAP_POLICY)) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(context, parser.text(), parser.getTokenLocation());
                    continue;
                }
                leftover.put(currentFieldName, parser.text());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                leftover.put(currentFieldName, parser.list());
                continue;
            }
            leftover.put(currentFieldName, parser.objectText());
        }
        if (bucketsPaths == null) {
            throw new SearchParseException(context, "Missing required field [" + BUCKETS_PATH.getPreferredName() + "] for aggregation [" + pipelineAggregatorName + "]", parser.getTokenLocation());
        }
        ValueFormatter formatter = null;
        formatter = format != null ? ValueFormat.Number.format(format).formatter() : ValueFormatter.RAW;
        PipelineAggregatorFactory factory = null;
        try {
            factory = this.buildFactory(pipelineAggregatorName, bucketsPaths, gapPolicy, formatter, leftover);
        }
        catch (ParseException exception) {
            throw new SearchParseException(context, "Could not parse settings for aggregation [" + pipelineAggregatorName + "].", null, exception);
        }
        if (leftover.size() > 0) {
            throw new SearchParseException(context, "Unexpected tokens " + leftover.keySet() + " in [" + pipelineAggregatorName + "].", null);
        }
        assert (factory != null);
        return factory;
    }

    protected abstract PipelineAggregatorFactory buildFactory(String var1, String[] var2, BucketHelpers.GapPolicy var3, ValueFormatter var4, Map<String, Object> var5) throws ParseException;
}

