/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.lookup.SourceLookup;

public class InternalSearchHit
implements SearchHit {
    private static final Object[] EMPTY_SORT_VALUES = new Object[0];
    private transient int docId;
    private float score = Float.NEGATIVE_INFINITY;
    private Text id;
    private Text type;
    private InternalNestedIdentity nestedIdentity;
    private long version = -1L;
    private BytesReference source;
    private Map<String, SearchHitField> fields = ImmutableMap.of();
    private Map<String, HighlightField> highlightFields = null;
    private Object[] sortValues = EMPTY_SORT_VALUES;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private Map<String, Object> sourceAsMap;
    private byte[] sourceAsBytes;
    private Map<String, InternalSearchHits> innerHits;

    private InternalSearchHit() {
    }

    public InternalSearchHit(int docId, String id, Text type, Map<String, SearchHitField> fields) {
        this.docId = docId;
        this.id = new Text(id);
        this.type = type;
        this.fields = fields;
    }

    public InternalSearchHit(int nestedTopDocId, String id, Text type, InternalNestedIdentity nestedIdentity, Map<String, SearchHitField> fields) {
        this.docId = nestedTopDocId;
        this.id = new Text(id);
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        this.shard = shardTarget;
        if (this.innerHits != null) {
            for (InternalSearchHits searchHits : this.innerHits.values()) {
                searchHits.shardTarget(shardTarget);
            }
        }
    }

    public void score(float score) {
        this.score = score;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public float getScore() {
        return this.score();
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String index() {
        return this.shard.index();
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public String id() {
        return this.id.string();
    }

    @Override
    public String getId() {
        return this.id();
    }

    @Override
    public String type() {
        return this.type.string();
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public SearchHit.NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    @Override
    public BytesReference sourceRef() {
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public InternalSearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsBytes = null;
        this.sourceAsMap = null;
        return this;
    }

    @Override
    public BytesReference getSourceRef() {
        return this.sourceRef();
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    @Override
    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = this.sourceRef().toBytes();
        return this.sourceAsBytes;
    }

    @Override
    public boolean isSourceEmpty() {
        return this.source == null;
    }

    @Override
    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    @Override
    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.sourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    @Override
    public String getSourceAsString() {
        return this.sourceAsString();
    }

    @Override
    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<SearchHitField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public SearchHitField field(String fieldName) {
        return this.fields().get(fieldName);
    }

    @Override
    public Map<String, SearchHitField> fields() {
        if (this.fields == null) {
            return ImmutableMap.of();
        }
        return this.fields;
    }

    public Map<String, SearchHitField> fieldsOrNull() {
        return this.fields;
    }

    @Override
    public Map<String, SearchHitField> getFields() {
        return this.fields();
    }

    public void fields(Map<String, SearchHitField> fields) {
        this.fields = fields;
    }

    public Map<String, HighlightField> internalHighlightFields() {
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> highlightFields() {
        if (this.highlightFields == null) {
            return ImmutableMap.of();
        }
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields();
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues) {
        Object[] sortValuesCopy = new Object[sortValues.length];
        System.arraycopy(sortValues, 0, sortValuesCopy, 0, sortValues.length);
        if (sortValues != null) {
            for (int i = 0; i < sortValues.length; ++i) {
                if (!(sortValues[i] instanceof BytesRef)) continue;
                sortValuesCopy[i] = new Text(new BytesArray((BytesRef)sortValues[i]));
            }
        }
        this.sortValues = sortValuesCopy;
    }

    @Override
    public Object[] sortValues() {
        return this.sortValues;
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues();
    }

    @Override
    public Explanation explanation() {
        return this.explanation;
    }

    @Override
    public Explanation getExplanation() {
        return this.explanation();
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public SearchShardTarget shard() {
        return this.shard;
    }

    @Override
    public SearchShardTarget getShard() {
        return this.shard();
    }

    public void shard(SearchShardTarget target) {
        this.shard = target;
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    @Override
    public String[] matchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, InternalSearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<SearchHitField> metaFields = new ArrayList<SearchHitField>();
        ArrayList<SearchHitField> otherFields = new ArrayList<SearchHitField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (SearchHitField searchHitField : this.fields.values()) {
                if (searchHitField.values().isEmpty()) continue;
                if (searchHitField.isMetadataField()) {
                    metaFields.add(searchHitField);
                    continue;
                }
                otherFields.add(searchHitField);
            }
        }
        builder.startObject();
        if (this.explanation() != null && this.shard != null) {
            builder.field("_shard", this.shard.shardId());
            builder.field("_node", this.shard.nodeIdText());
        }
        if (this.shard != null) {
            builder.field(Fields._INDEX, this.shard.indexText());
        }
        builder.field(Fields._TYPE, this.type);
        builder.field(Fields._ID, this.id);
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        }
        if (this.version != -1L) {
            builder.field(Fields._VERSION, this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField(Fields._SCORE);
        } else {
            builder.field(Fields._SCORE, this.score);
        }
        for (SearchHitField searchHitField : metaFields) {
            builder.field(searchHitField.name(), searchHitField.value());
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject(Fields.FIELDS);
            for (SearchHitField searchHitField : otherFields) {
                builder.startArray(searchHitField.name());
                for (Object value : searchHitField.getValues()) {
                    builder.value(value);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject(Fields.HIGHLIGHT);
            for (HighlightField highlightField : this.highlightFields.values()) {
                builder.field(highlightField.name());
                if (highlightField.fragments() == null) {
                    builder.nullValue();
                    continue;
                }
                builder.startArray();
                for (Text fragment : highlightField.fragments()) {
                    builder.value(fragment);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.sortValues != null && this.sortValues.length > 0) {
            builder.startArray(Fields.SORT);
            for (Object sortValue : this.sortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        if (this.matchedQueries.length > 0) {
            builder.startArray(Fields.MATCHED_QUERIES);
            for (String matchedFilter : this.matchedQueries) {
                builder.value(matchedFilter);
            }
            builder.endArray();
        }
        if (this.explanation() != null) {
            builder.field(Fields._EXPLANATION);
            this.buildExplanation(builder, this.explanation());
        }
        if (this.innerHits != null) {
            builder.startObject(Fields.INNER_HITS);
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field(Fields.VALUE, explanation.getValue());
        builder.field(Fields.DESCRIPTION, explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray(Fields.DETAILS);
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static InternalSearchHit readSearchHit(StreamInput in, InternalSearchHits.StreamContext context) throws IOException {
        InternalSearchHit hit = new InternalSearchHit();
        hit.readFrom(in, context);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.readFrom(in, InternalSearchHits.streamContext().streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.STREAM));
    }

    public void readFrom(StreamInput in, InternalSearchHits.StreamContext context) throws IOException {
        int lookupId;
        HighlightField field3;
        HighlightField field1;
        ImmutableMap.Builder builder;
        InternalSearchHitField hitField4;
        InternalSearchHitField hitField3;
        InternalSearchHitField hitField1;
        int size;
        this.score = in.readFloat();
        this.id = in.readText();
        this.type = in.readText();
        this.nestedIdentity = in.readOptionalStreamable(new InternalNestedIdentity());
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = ImmutableMap.of();
        } else if (size == 1) {
            InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of((Object)hitField.name(), (Object)hitField);
        } else if (size == 2) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of((Object)hitField1.name(), (Object)hitField1, (Object)hitField2.name(), (Object)hitField2);
        } else if (size == 3) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of((Object)hitField1.name(), (Object)hitField1, (Object)hitField2.name(), (Object)hitField2, (Object)hitField3.name(), (Object)hitField3);
        } else if (size == 4) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            hitField4 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of((Object)hitField1.name(), (Object)hitField1, (Object)hitField2.name(), (Object)hitField2, (Object)hitField3.name(), (Object)hitField3, (Object)hitField4.name(), (Object)hitField4);
        } else if (size == 5) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            hitField4 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField5 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of((Object)hitField1.name(), (Object)hitField1, (Object)hitField2.name(), (Object)hitField2, (Object)hitField3.name(), (Object)hitField3, (Object)hitField4.name(), (Object)hitField4, (Object)hitField5.name(), (Object)hitField5);
        } else {
            builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
                builder.put((Object)hitField.name(), (Object)hitField);
            }
            this.fields = builder.build();
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = ImmutableMap.of();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of((Object)field.name(), (Object)field);
        } else if (size == 2) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of((Object)field1.name(), (Object)field1, (Object)field2.name(), (Object)field2);
        } else if (size == 3) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            field3 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of((Object)field1.name(), (Object)field1, (Object)field2.name(), (Object)field2, (Object)field3.name(), (Object)field3);
        } else if (size == 4) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            field3 = HighlightField.readHighlightField(in);
            HighlightField field4 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of((Object)field1.name(), (Object)field1, (Object)field2.name(), (Object)field2, (Object)field3.name(), (Object)field3, (Object)field4.name(), (Object)field4);
        } else {
            builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                builder.put((Object)field.name(), (Object)field);
            }
            this.highlightFields = builder.build();
        }
        size = in.readVInt();
        if (size > 0) {
            this.sortValues = new Object[size];
            for (int i = 0; i < this.sortValues.length; ++i) {
                byte type = in.readByte();
                if (type == 0) {
                    this.sortValues[i] = null;
                    continue;
                }
                if (type == 1) {
                    this.sortValues[i] = in.readString();
                    continue;
                }
                if (type == 2) {
                    this.sortValues[i] = in.readInt();
                    continue;
                }
                if (type == 3) {
                    this.sortValues[i] = in.readLong();
                    continue;
                }
                if (type == 4) {
                    this.sortValues[i] = Float.valueOf(in.readFloat());
                    continue;
                }
                if (type == 5) {
                    this.sortValues[i] = in.readDouble();
                    continue;
                }
                if (type == 6) {
                    this.sortValues[i] = in.readByte();
                    continue;
                }
                if (type == 7) {
                    this.sortValues[i] = in.readShort();
                    continue;
                }
                if (type == 8) {
                    this.sortValues[i] = in.readBoolean();
                    continue;
                }
                if (type == 9) {
                    this.sortValues[i] = in.readText();
                    continue;
                }
                throw new IOException("Can't match type [" + type + "]");
            }
        }
        if ((size = in.readVInt()) > 0) {
            this.matchedQueries = new String[size];
            for (int i = 0; i < size; ++i) {
                this.matchedQueries[i] = in.readString();
            }
        }
        if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.STREAM) {
            if (in.readBoolean()) {
                this.shard = SearchShardTarget.readSearchShardTarget(in);
            }
        } else if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.LOOKUP && (lookupId = in.readVInt()) > 0) {
            this.shard = (SearchShardTarget)context.handleShardLookup().get(lookupId);
        }
        if ((size = in.readVInt()) > 0) {
            this.innerHits = new HashMap<String, InternalSearchHits>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                InternalSearchHits.StreamContext.ShardTargetType shardTarget = context.streamShardTarget();
                InternalSearchHits value = InternalSearchHits.readSearchHits(in, context.streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.NO_STREAM));
                context.streamShardTarget(shardTarget);
                this.innerHits.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, InternalSearchHits.streamContext().streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.STREAM));
    }

    public void writeTo(StreamOutput out, InternalSearchHits.StreamContext context) throws IOException {
        out.writeFloat(this.score);
        out.writeText(this.id);
        out.writeText(this.type);
        out.writeOptionalStreamable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (SearchHitField searchHitField : this.fields().values()) {
                searchHitField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        if (this.sortValues.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.sortValues.length);
            for (Iterator<Streamable> iterator : this.sortValues) {
                if (iterator == null) {
                    out.writeByte((byte)0);
                    continue;
                }
                Class<?> type = iterator.getClass();
                if (type == String.class) {
                    out.writeByte((byte)1);
                    out.writeString((String)((Object)iterator));
                    continue;
                }
                if (type == Integer.class) {
                    out.writeByte((byte)2);
                    out.writeInt((Integer)((Object)iterator));
                    continue;
                }
                if (type == Long.class) {
                    out.writeByte((byte)3);
                    out.writeLong((Long)((Object)iterator));
                    continue;
                }
                if (type == Float.class) {
                    out.writeByte((byte)4);
                    out.writeFloat(((Float)((Object)iterator)).floatValue());
                    continue;
                }
                if (type == Double.class) {
                    out.writeByte((byte)5);
                    out.writeDouble((Double)((Object)iterator));
                    continue;
                }
                if (type == Byte.class) {
                    out.writeByte((byte)6);
                    out.writeByte((Byte)((Object)iterator));
                    continue;
                }
                if (type == Short.class) {
                    out.writeByte((byte)7);
                    out.writeShort((Short)((Object)iterator));
                    continue;
                }
                if (type == Boolean.class) {
                    out.writeByte((byte)8);
                    out.writeBoolean((Boolean)((Object)iterator));
                    continue;
                }
                if (iterator instanceof Text) {
                    out.writeByte((byte)9);
                    out.writeText((Text)((Object)iterator));
                    continue;
                }
                throw new IOException("Can't handle sort field value of type [" + type + "]");
            }
        }
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (Iterator<Streamable> iterator : this.matchedQueries) {
                out.writeString((String)((Object)iterator));
            }
        }
        if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.STREAM) {
            if (this.shard == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.shard.writeTo(out);
            }
        } else if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.LOOKUP) {
            if (this.shard == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(context.shardHandleLookup().get(this.shard));
            }
        }
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                InternalSearchHits.StreamContext.ShardTargetType shardTarget = context.streamShardTarget();
                ((InternalSearchHits)entry.getValue()).writeTo(out, context.streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.NO_STREAM));
                context.streamShardTarget(shardTarget);
            }
        }
    }

    public static final class InternalNestedIdentity
    implements SearchHit.NestedIdentity,
    Streamable,
    ToXContent {
        private Text field;
        private int offset;
        private InternalNestedIdentity child;

        public InternalNestedIdentity(String field, int offset, InternalNestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        InternalNestedIdentity() {
        }

        @Override
        public Text getField() {
            return this.field;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public SearchHit.NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalStreamable(new InternalNestedIdentity());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalStreamable(this.child);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields._NESTED);
            if (this.field != null) {
                builder.field(Fields._NESTED_FIELD, this.field);
            }
            if (this.offset != -1) {
                builder.field(Fields._NESTED_OFFSET, this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public static class Fields {
            static final XContentBuilderString _NESTED = new XContentBuilderString("_nested");
            static final XContentBuilderString _NESTED_FIELD = new XContentBuilderString("field");
            static final XContentBuilderString _NESTED_OFFSET = new XContentBuilderString("offset");
        }
    }

    public static class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString _SCORE = new XContentBuilderString("_score");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");
        static final XContentBuilderString HIGHLIGHT = new XContentBuilderString("highlight");
        static final XContentBuilderString SORT = new XContentBuilderString("sort");
        static final XContentBuilderString MATCHED_QUERIES = new XContentBuilderString("matched_queries");
        static final XContentBuilderString _EXPLANATION = new XContentBuilderString("_explanation");
        static final XContentBuilderString VALUE = new XContentBuilderString("value");
        static final XContentBuilderString DESCRIPTION = new XContentBuilderString("description");
        static final XContentBuilderString DETAILS = new XContentBuilderString("details");
        static final XContentBuilderString INNER_HITS = new XContentBuilderString("inner_hits");
    }
}

