/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrimitiveTransferable
implements Transferable {
    public static final DataFlavor PRIMITIVE_DATA = new DataFlavor(Data.class, Data.class.getName());
    private final Collection<? extends OsmPrimitive> primitives;

    public PrimitiveTransferable(Collection<? extends OsmPrimitive> collection) {
        this.primitives = collection;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{PRIMITIVE_DATA, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor == PRIMITIVE_DATA;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getStringData();
        }
        if (PRIMITIVE_DATA.equals(dataFlavor)) {
            return this.getPrimitiveData();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected String getStringData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive osmPrimitive : this.primitives) {
            stringBuilder.append((Object)osmPrimitive.getType()).append(' ').append(osmPrimitive.getUniqueId()).append(" # ").append(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())).append('\n');
        }
        return stringBuilder.toString().replace("\u200e", "").replace("\u200f", "");
    }

    protected Data getPrimitiveData() {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>(this.primitives.size());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            arrayList.add(osmPrimitive.save());
        }
        return new Data(arrayList);
    }

    public static final class Data
    implements Serializable {
        private static final long serialVersionUID = -1485089993600213704L;
        private final Collection<PrimitiveData> primitiveData;

        private Data(Collection<PrimitiveData> collection) {
            CheckParameterUtil.ensureThat(collection instanceof Serializable, "primitiveData must be instanceof Serializable");
            this.primitiveData = collection;
        }

        public Collection<PrimitiveData> getPrimitiveData() {
            return this.primitiveData;
        }
    }
}

