/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.MissingValue;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class AsUnsignedNode
extends PackNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumNode;
    private static final long UNSIGNED_LONG_MASK = Long.MAX_VALUE;

    public AsUnsignedNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public MissingValue asUnsigned(VirtualFrame frame, MissingValue missingValue) {
        return missingValue;
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject asUnsigned(VirtualFrame frame, DynamicObject nil) {
        return nil;
    }

    @Specialization
    public int asUnsigned(VirtualFrame frame, short value) {
        return value & 0xFFFF;
    }

    @Specialization
    public long asUnsigned(VirtualFrame frame, int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    @Specialization
    public Object asUnsigned(VirtualFrame frame, long value) {
        if (this.fixnumOrBignumNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.fixnumOrBignumNode = this.insert(FixnumOrBignumNode.create(this.getContext(), this.getSourceSection()));
        }
        return this.fixnumOrBignumNode.fixnumOrBignum(this.asUnsigned(value));
    }

    @CompilerDirectives.TruffleBoundary
    private BigInteger asUnsigned(long value) {
        BigInteger bigIntegerValue = BigInteger.valueOf(value & Long.MAX_VALUE);
        if (value < 0L) {
            bigIntegerValue = bigIntegerValue.setBit(63);
        }
        return bigIntegerValue;
    }
}

