/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.conversion;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToJavaStringNode
extends RubyNode {
    public ToJavaStringNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract String executeJavaString(VirtualFrame var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubySymbol(symbol)"})
    protected String toJavaStringSymbol(DynamicObject symbol) {
        return Layouts.SYMBOL.getString(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyString(string)"})
    protected String toJavaStringString(DynamicObject string) {
        return string.toString();
    }

    @Specialization
    protected String toJavaString(String string) {
        return string;
    }
}

