/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameContainer;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParcelDescriptor;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Parcel
implements XNameContainer {
    private ParcelDescriptor m_descriptor;
    private String name;
    protected ParcelContainer parent;
    protected XSimpleFileAccess m_xSFA;

    public Parcel(XSimpleFileAccess xSFA, ParcelContainer parent, ParcelDescriptor desc, String parcelName) {
        this(parent, desc, parcelName);
        this.m_xSFA = xSFA;
    }

    private Parcel(ParcelContainer parent, ParcelDescriptor desc, String parcelName) {
        this.parent = parent;
        this.m_descriptor = desc;
        this.name = parcelName;
    }

    public boolean isUnoPkg() {
        return this.parent.isUnoPkg();
    }

    public String getName() {
        return this.name;
    }

    public Object getByName(String aName) throws NoSuchElementException, WrappedTargetException {
        ScriptEntry thescript;
        block4: {
            LogUtils.DEBUG("** Parcel.getByName for " + aName);
            thescript = null;
            try {
                ScriptEntry[] scripts;
                if (this.m_descriptor == null || !this.hasElements() || (scripts = this.m_descriptor.getScriptEntries()).length == 0) break block4;
                for (ScriptEntry script : scripts) {
                    if (!script.getLanguageName().equals(aName)) continue;
                    thescript = script;
                    break;
                }
            }
            catch (Exception e) {
                throw new WrappedTargetException((Throwable)e);
            }
        }
        if (thescript == null) {
            LogUtils.DEBUG("No script for " + aName);
            throw new NoSuchElementException("No script named " + aName);
        }
        ScriptMetaData data = new ScriptMetaData(this, thescript, null);
        LogUtils.DEBUG("returning date  for " + aName);
        return data;
    }

    public String[] getElementNames() {
        String[] results = new String[]{};
        if (this.m_descriptor != null) {
            ScriptEntry[] scripts = this.m_descriptor.getScriptEntries();
            results = new String[scripts.length];
            for (int index = 0; index < scripts.length; ++index) {
                results[index] = scripts[index].getLanguageName();
            }
        }
        return results;
    }

    public boolean hasByName(String aName) {
        boolean result = true;
        Object containee = null;
        try {
            containee = this.getByName(aName);
            if (containee != null) {
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        return this.m_descriptor != null && this.m_descriptor.getScriptEntries().length > 0;
    }

    public void replaceByName(String aName, Object aElement) throws IllegalArgumentException, NoSuchElementException, WrappedTargetException {
        if (this.m_descriptor != null) {
            try {
                ScriptEntry script = (ScriptEntry)this.getByName(aName);
                if (script == null) {
                    throw new NoSuchElementException("No script named " + aName);
                }
            }
            catch (Exception ex) {
                throw new WrappedTargetException((Throwable)ex);
            }
        }
    }

    public void insertByName(String aName, Object aElement) throws IllegalArgumentException, ElementExistException, WrappedTargetException {
        try {
            if (this.hasByName(aName)) {
                throw new ElementExistException(aName);
            }
            ScriptMetaData script = (ScriptMetaData)aElement;
            if (script.hasSource()) {
                LogUtils.DEBUG("Inserting source: " + script.getSource());
                if (!script.writeSourceFile()) {
                    throw new WrappedTargetException("Failed to create source file " + script.getLanguageName());
                }
            }
            this.m_descriptor.addScriptEntry(script);
            this.writeParcelDescriptor();
        }
        catch (Exception e) {
            LogUtils.DEBUG("Failed to insert entry " + aName + ": " + e.getMessage());
            throw new WrappedTargetException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParcelDescriptor() throws CommandAbortedException, com.sun.star.io.IOException, com.sun.star.uno.Exception, IOException {
        String pathToDescriptor = PathUtils.make_url(this.getPathToParcel(), "parcel-descriptor.xml");
        XSimpleFileAccess2 xSFA2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)this.m_xSFA);
        if (xSFA2 != null) {
            ByteArrayOutputStream bos = null;
            ByteArrayInputStream bis = null;
            XInputStreamImpl xis = null;
            try {
                bos = new ByteArrayOutputStream(1024);
                this.m_descriptor.write(bos);
                bis = new ByteArrayInputStream(bos.toByteArray());
                xis = new XInputStreamImpl(bis);
                xSFA2.writeFile(pathToDescriptor, (XInputStream)xis);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (xis != null) {
                    xis.closeInput();
                }
            }
        }
    }

    public void removeByName(String Name) throws NoSuchElementException, WrappedTargetException {
        try {
            ScriptMetaData script = (ScriptMetaData)this.getByName(Name);
            if (script != null) {
                if (!script.removeSourceFile()) {
                    LogUtils.DEBUG("** Parcel.removeByName Failed to remove script " + Name);
                    throw new WrappedTargetException("Failed to remove script " + Name);
                }
            } else {
                throw new NoSuchElementException("No script named " + Name);
            }
            LogUtils.DEBUG("** Parcel.removeByName have removed script source file " + Name);
            this.m_descriptor.removeScriptEntry(script);
            this.writeParcelDescriptor();
        }
        catch (Exception e) {
            LogUtils.DEBUG("** Parcel.removeByName Exception: " + e);
            throw new WrappedTargetException((Throwable)e);
        }
    }

    public void rename(String name) {
        this.name = name;
    }

    public ParcelContainer getParent() {
        return this.parent;
    }

    public String getPathToParcel() {
        String path = this.parent.getParcelContainerDir() + "/" + this.name;
        return path;
    }
}

