/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.deflate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jboss.netty.buffer.ChannelBuffer;

public class DeflateCompressor
implements Compressor {
    private static final byte[] HEADER = new byte[]{68, 70, 76, 0};
    private static final int LEVEL = 3;
    private static final int BUFFER_SIZE = 4096;

    @Override
    public boolean isCompressed(BytesReference bytes) {
        if (bytes.length() < HEADER.length) {
            return false;
        }
        for (int i = 0; i < HEADER.length; ++i) {
            if (bytes.get(i) == HEADER[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompressed(ChannelBuffer buffer) {
        if (buffer.readableBytes() < HEADER.length) {
            return false;
        }
        int offset = buffer.readerIndex();
        for (int i = 0; i < HEADER.length; ++i) {
            if (buffer.getByte(offset + i) == HEADER[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public StreamInput streamInput(StreamInput in) throws IOException {
        int len;
        int read;
        byte[] headerBytes = new byte[HEADER.length];
        for (len = 0; len < headerBytes.length && (read = in.read(headerBytes, len, headerBytes.length - len)) != -1; len += read) {
        }
        if (len != HEADER.length || !Arrays.equals(headerBytes, HEADER)) {
            throw new IllegalArgumentException("Input stream is not compressed with DEFLATE!");
        }
        boolean nowrap = true;
        final Inflater inflater = new Inflater(true);
        FilterInputStream decompressedIn = new InflaterInputStream(in, inflater, 4096);
        decompressedIn = new BufferedInputStream(decompressedIn, 4096);
        return new InputStreamStreamInput(decompressedIn){
            private boolean closed;
            {
                super(is);
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (!this.closed) {
                        inflater.end();
                        this.closed = true;
                    }
                }
            }
        };
    }

    @Override
    public StreamOutput streamOutput(StreamOutput out) throws IOException {
        out.writeBytes(HEADER);
        boolean nowrap = true;
        final Deflater deflater = new Deflater(3, true);
        boolean syncFlush = true;
        FilterOutputStream compressedOut = new DeflaterOutputStream(out, deflater, 4096, true);
        compressedOut = new BufferedOutputStream(compressedOut, 4096);
        return new OutputStreamStreamOutput(compressedOut){
            private boolean closed;
            {
                super(out);
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (!this.closed) {
                        deflater.end();
                        this.closed = true;
                    }
                }
            }
        };
    }

    @Override
    public boolean isCompressed(IndexInput in) throws IOException {
        return false;
    }

    @Override
    public CompressedIndexInput indexInput(IndexInput in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

