var isSymbol = require('./isSymbol');

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(key) {
  return (typeof key == 'string' || isSymbol(key)) ? key : (key + '');
}

module.exports = toKey;
