/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.GraphicsBox;
import org.scilab.forge.jlatexmath.ParseOption;
import org.scilab.forge.jlatexmath.ResizeAtom;
import org.scilab.forge.jlatexmath.RotateAtom;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;

public class GraphicsAtom
extends Atom {
    private Image image = null;
    private BufferedImage bimage;
    private Label c;
    private int w;
    private int h;
    private Atom base;
    private boolean first = true;
    private int interp = -1;

    public GraphicsAtom(String string, String string2) {
        Serializable serializable;
        File file = new File(string);
        if (!file.exists()) {
            try {
                serializable = new URL(string);
                this.image = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            }
            catch (MalformedURLException malformedURLException) {
                this.image = null;
            }
        } else {
            this.image = Toolkit.getDefaultToolkit().getImage(string);
        }
        if (this.image != null) {
            this.c = new Label();
            serializable = new MediaTracker(this.c);
            ((MediaTracker)serializable).addImage(this.image, 0);
            try {
                ((MediaTracker)serializable).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                this.image = null;
            }
        }
        this.draw();
        this.buildAtom(string2);
    }

    protected void buildAtom(String string) {
        this.base = this;
        Map<String, String> map = ParseOption.parseMap(string);
        if (map.containsKey("width") || map.containsKey("height")) {
            this.base = new ResizeAtom(this.base, map.get("width"), map.get("height"), map.containsKey("keepaspectratio"));
        }
        if (map.containsKey("scale")) {
            double d = Double.parseDouble(map.get("scale"));
            this.base = new ScaleAtom(this.base, d, d);
        }
        if (map.containsKey("angle") || map.containsKey("origin")) {
            this.base = new RotateAtom(this.base, map.get("angle"), map.get("origin"));
        }
        if (map.containsKey("interpolation")) {
            String string2 = map.get("interpolation");
            if (string2.equalsIgnoreCase("bilinear")) {
                this.interp = 0;
            } else if (string2.equalsIgnoreCase("bicubic")) {
                this.interp = 2;
            } else if (string2.equalsIgnoreCase("nearest_neighbor")) {
                this.interp = 1;
            }
        }
    }

    public void draw() {
        if (this.image != null) {
            this.w = this.image.getWidth(this.c);
            this.h = this.image.getHeight(this.c);
            this.bimage = new BufferedImage(this.w, this.h, 2);
            Graphics2D graphics2D = this.bimage.createGraphics();
            graphics2D.drawImage(this.image, 0, 0, null);
            graphics2D.dispose();
        }
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.image != null) {
            if (this.first) {
                this.first = false;
                return this.base.createBox(teXEnvironment);
            }
            teXEnvironment.isColored = true;
            float f = (float)this.w * SpaceAtom.getFactor(2, teXEnvironment);
            float f2 = (float)this.h * SpaceAtom.getFactor(2, teXEnvironment);
            return new GraphicsBox(this.bimage, f, f2, teXEnvironment.getSize(), this.interp);
        }
        return new TeXFormula((String)"\\text{ No such image file ! }").root.createBox(teXEnvironment);
    }
}

