/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.BreakFormula;
import org.scilab.forge.jlatexmath.BreakMarkAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidAtomTypeException;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PredefMacros;
import org.scilab.forge.jlatexmath.PredefinedCommands;
import org.scilab.forge.jlatexmath.PredefinedTeXFormulaParser;
import org.scilab.forge.jlatexmath.PredefinedTeXFormulas;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormulaSettingsParser;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.VCenteredAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeXFormula {
    public static final String VERSION = "1.0.3";
    public static final int SERIF = 0;
    public static final int SANSSERIF = 1;
    public static final int BOLD = 2;
    public static final int ITALIC = 4;
    public static final int ROMAN = 8;
    public static final int TYPEWRITER = 16;
    private static final String[][] delimiterNames = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
    public static float PIXELS_PER_POINT = 1.0f;
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    protected static final float PREC = 1.0E-7f;
    public static Map<String, TeXFormula> predefinedTeXFormulas = new HashMap<String, TeXFormula>(150);
    public static Map<String, String> predefinedTeXFormulasAsString = new HashMap<String, String>(150);
    public static String[] symbolMappings = new String[65536];
    public static String[] symbolTextMappings = new String[65536];
    public static String[] symbolFormulaMappings = new String[65536];
    public static Map<Character.UnicodeBlock, FontInfos> externalFontMap = new HashMap<Character.UnicodeBlock, FontInfos>();
    public List<MiddleAtom> middle = new LinkedList<MiddleAtom>();
    protected Map<String, String> jlmXMLMap;
    private TeXParser parser;
    public Atom root = null;
    public String textStyle = null;
    public boolean isColored = false;

    public static void addSymbolMappings(String string) throws ResourceParseException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        TeXFormula.addSymbolMappings(fileInputStream, string);
    }

    public static void addSymbolMappings(InputStream inputStream, String string) throws ResourceParseException {
        TeXFormulaSettingsParser teXFormulaSettingsParser = new TeXFormulaSettingsParser(inputStream, string);
        teXFormulaSettingsParser.parseSymbolMappings(symbolMappings, symbolTextMappings);
        teXFormulaSettingsParser.parseSymbolToFormulaMappings(symbolFormulaMappings, symbolTextMappings);
    }

    public static boolean isRegisteredBlock(Character.UnicodeBlock unicodeBlock) {
        return externalFontMap.get(unicodeBlock) != null;
    }

    public static FontInfos getExternalFont(Character.UnicodeBlock unicodeBlock) {
        FontInfos fontInfos = externalFontMap.get(unicodeBlock);
        if (fontInfos == null) {
            fontInfos = new FontInfos("SansSerif", "Serif");
            externalFontMap.put(unicodeBlock, fontInfos);
        }
        return fontInfos;
    }

    public static void registerExternalFont(Character.UnicodeBlock unicodeBlock, String string, String string2) {
        if (string == null && string2 == null) {
            externalFontMap.remove(unicodeBlock);
            return;
        }
        externalFontMap.put(unicodeBlock, new FontInfos(string, string2));
        if (unicodeBlock.equals(Character.UnicodeBlock.BASIC_LATIN)) {
            predefinedTeXFormulas.clear();
        }
    }

    public static void registerExternalFont(Character.UnicodeBlock unicodeBlock, String string) {
        TeXFormula.registerExternalFont(unicodeBlock, string, string);
    }

    public static void setDPITarget(float f) {
        PIXELS_PER_POINT = f / 72.0f;
    }

    public static void setDefaultDPI() {
        if (!GraphicsEnvironment.isHeadless()) {
            TeXFormula.setDPITarget(Toolkit.getDefaultToolkit().getScreenResolution());
        }
    }

    public TeXFormula() {
        this.parser = new TeXParser("", this, false);
    }

    public TeXFormula(String string, Map<String, String> map) throws ParseException {
        this.jlmXMLMap = map;
        this.textStyle = this.textStyle;
        this.parser = new TeXParser(string, this);
        this.parser.parse();
    }

    public TeXFormula(String string) throws ParseException {
        this(string, (String)null);
    }

    public TeXFormula(String string, boolean bl) throws ParseException {
        this.textStyle = null;
        this.parser = new TeXParser(string, this, bl);
        this.parser.parse();
    }

    public TeXFormula(String string, String string2) throws ParseException {
        this.textStyle = string2;
        this.parser = new TeXParser(string, this);
        this.parser.parse();
    }

    public TeXFormula(String string, String string2, boolean bl, boolean bl2) throws ParseException {
        this.textStyle = string2;
        this.parser = new TeXParser(string, this, bl, bl2);
        this.parser.parse();
    }

    public TeXFormula(TeXFormula teXFormula) {
        if (teXFormula != null) {
            this.addImpl(teXFormula);
        }
    }

    protected TeXFormula(TeXParser teXParser) {
        this.jlmXMLMap = teXParser.formula.jlmXMLMap;
        this.parser = new TeXParser(teXParser.getIsPartial(), "", this, false);
    }

    protected TeXFormula(TeXParser teXParser, String string) throws ParseException {
        this(teXParser, string, null);
    }

    protected TeXFormula(TeXParser teXParser, String string, boolean bl) throws ParseException {
        this.textStyle = null;
        this.jlmXMLMap = teXParser.formula.jlmXMLMap;
        boolean bl2 = teXParser.getIsPartial();
        this.parser = new TeXParser(bl2, string, this, bl);
        if (bl2) {
            try {
                this.parser.parse();
            }
            catch (Exception exception) {}
        } else {
            this.parser.parse();
        }
    }

    protected TeXFormula(TeXParser teXParser, String string, String string2) throws ParseException {
        this.textStyle = string2;
        this.jlmXMLMap = teXParser.formula.jlmXMLMap;
        boolean bl = teXParser.getIsPartial();
        this.parser = new TeXParser(bl, string, this);
        if (bl) {
            try {
                this.parser.parse();
            }
            catch (Exception exception) {
                if (this.root == null) {
                    this.root = new EmptyAtom();
                }
            }
        } else {
            this.parser.parse();
        }
    }

    protected TeXFormula(TeXParser teXParser, String string, String string2, boolean bl, boolean bl2) throws ParseException {
        this.textStyle = string2;
        this.jlmXMLMap = teXParser.formula.jlmXMLMap;
        boolean bl3 = teXParser.getIsPartial();
        this.parser = new TeXParser(bl3, string, this, bl, bl2);
        if (bl3) {
            try {
                this.parser.parse();
            }
            catch (Exception exception) {
                if (this.root == null) {
                    this.root = new EmptyAtom();
                }
            }
        } else {
            this.parser.parse();
        }
    }

    public static TeXFormula getAsText(String string, int n) throws ParseException {
        TeXFormula teXFormula = new TeXFormula();
        if (string == null || "".equals(string)) {
            teXFormula.add(new EmptyAtom());
            return teXFormula;
        }
        String[] stringArray = string.split("\n|\\\\\\\\|\\\\cr");
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        for (String string2 : stringArray) {
            TeXFormula teXFormula2 = new TeXFormula(string2, "mathnormal", true, false);
            arrayOfAtoms.add(new RomanAtom(teXFormula2.root));
            arrayOfAtoms.addRow();
        }
        arrayOfAtoms.checkDimensions();
        teXFormula.add(new MatrixAtom(false, arrayOfAtoms, 0, n));
        return teXFormula;
    }

    public static TeXFormula getPartialTeXFormula(String string) {
        TeXFormula teXFormula;
        block3: {
            teXFormula = new TeXFormula();
            if (string == null) {
                teXFormula.add(new EmptyAtom());
                return teXFormula;
            }
            TeXParser teXParser = new TeXParser(true, string, teXFormula);
            try {
                teXParser.parse();
            }
            catch (Exception exception) {
                if (teXFormula.root != null) break block3;
                teXFormula.root = new EmptyAtom();
            }
        }
        return teXFormula;
    }

    public static void registerFonts(boolean bl) {
        DefaultTeXFontParser.registerFonts(bl);
    }

    public void setLaTeX(String string) throws ParseException {
        this.parser.reset(string);
        if (string != null && string.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula add(Atom atom) {
        if (atom != null) {
            if (atom instanceof MiddleAtom) {
                this.middle.add((MiddleAtom)atom);
            }
            if (this.root == null) {
                this.root = atom;
            } else {
                TypedAtom typedAtom;
                int n;
                if (!(this.root instanceof RowAtom)) {
                    this.root = new RowAtom(this.root);
                }
                ((RowAtom)this.root).add(atom);
                if (atom instanceof TypedAtom && ((n = (typedAtom = (TypedAtom)atom).getRightType()) == 2 || n == 3)) {
                    ((RowAtom)this.root).add(new BreakMarkAtom());
                }
            }
        }
        return this;
    }

    public TeXFormula add(String string) throws ParseException {
        if (string != null && string.length() != 0) {
            this.textStyle = null;
            this.add(new TeXFormula(string));
        }
        return this;
    }

    public TeXFormula append(String string) throws ParseException {
        return this.append(false, string);
    }

    public TeXFormula append(boolean bl, String string) throws ParseException {
        if (string != null && string.length() != 0) {
            TeXParser teXParser = new TeXParser(bl, string, this);
            teXParser.parse();
        }
        return this;
    }

    public TeXFormula add(TeXFormula teXFormula) {
        this.addImpl(teXFormula);
        return this;
    }

    private void addImpl(TeXFormula teXFormula) {
        if (teXFormula.root != null) {
            if (teXFormula.root instanceof RowAtom) {
                this.add(new RowAtom(teXFormula.root));
            } else {
                this.add(teXFormula.root);
            }
        }
    }

    public void setLookAtLastAtom(boolean bl) {
        if (this.root instanceof RowAtom) {
            ((RowAtom)this.root).lookAtLastAtom = bl;
        }
    }

    public boolean getLookAtLastAtom() {
        if (this.root instanceof RowAtom) {
            return ((RowAtom)this.root).lookAtLastAtom;
        }
        return false;
    }

    public TeXFormula centerOnAxis() {
        this.root = new VCenteredAtom(this.root);
        return this;
    }

    public static void addPredefinedTeXFormula(InputStream inputStream) throws ResourceParseException {
        new PredefinedTeXFormulaParser(inputStream, "TeXFormula").parse(predefinedTeXFormulas);
    }

    public static void addPredefinedCommands(InputStream inputStream) throws ResourceParseException {
        new PredefinedTeXFormulaParser(inputStream, "Command").parse(MacroInfo.Commands);
    }

    public TeXFormula addStrut(int n, float f, float f2, float f3) throws InvalidUnitException {
        return this.add(new SpaceAtom(n, f, f2, f3));
    }

    public TeXFormula addStrut(int n) throws InvalidUnitException {
        return this.add(new SpaceAtom(n));
    }

    public TeXFormula addStrut(int n, float f, int n2, float f2, int n3, float f3) throws InvalidUnitException {
        return this.add(new SpaceAtom(n, f, n2, f2, n3, f3));
    }

    private Box createBox(TeXEnvironment teXEnvironment) {
        if (this.root == null) {
            return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.root.createBox(teXEnvironment);
    }

    private DefaultTeXFont createFont(float f, int n) {
        DefaultTeXFont defaultTeXFont = new DefaultTeXFont(f);
        if (n == 0) {
            defaultTeXFont.setSs(false);
        }
        if ((n & 8) != 0) {
            defaultTeXFont.setRoman(true);
        }
        if ((n & 0x10) != 0) {
            defaultTeXFont.setTt(true);
        }
        if ((n & 1) != 0) {
            defaultTeXFont.setSs(true);
        }
        if ((n & 4) != 0) {
            defaultTeXFont.setIt(true);
        }
        if ((n & 2) != 0) {
            defaultTeXFont.setBold(true);
        }
        return defaultTeXFont;
    }

    public TeXIcon createTeXIcon(int n, float f) {
        return new TeXIconBuilder().setStyle(n).setSize(f).build();
    }

    public TeXIcon createTeXIcon(int n, float f, int n2) {
        return new TeXIconBuilder().setStyle(n).setSize(f).setType(n2).build();
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, Color color) {
        return new TeXIconBuilder().setStyle(n).setSize(f).setType(n2).setFGColor(color).build();
    }

    public TeXIcon createTeXIcon(int n, float f, boolean bl) {
        return new TeXIconBuilder().setStyle(n).setSize(f).setTrueValues(bl).build();
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, float f2, int n3) {
        return this.createTeXIcon(n, f, 0, n2, f2, n3);
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, int n3, float f2, int n4) {
        return new TeXIconBuilder().setStyle(n).setSize(f).setType(n2).setWidth(n3, f2, n4).build();
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, float f2, int n3, int n4, float f3) {
        return this.createTeXIcon(n, f, 0, n2, f2, n3, n4, f3);
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, int n3, float f2, int n4, int n5, float f3) {
        return new TeXIconBuilder().setStyle(n).setSize(f).setType(n2).setWidth(n3, f2, n4).setInterLineSpacing(n5, f3).build();
    }

    public void createImage(String string, int n, float f, String string2, Color color, Color color2, boolean bl) {
        TeXIcon teXIcon = this.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(1, 1, 1, 1));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, bl ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color != null && !bl) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color2);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        try {
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(new File(string2));
            ImageIO.write((RenderedImage)bufferedImage, string, fileImageOutputStream);
            fileImageOutputStream.flush();
            fileImageOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("I/O error : Cannot generate " + string2);
        }
        graphics2D.dispose();
    }

    public void createPNG(int n, float f, String string, Color color, Color color2) {
        this.createImage("png", n, f, string, color, color2, color == null);
    }

    public void createGIF(int n, float f, String string, Color color, Color color2) {
        this.createImage("gif", n, f, string, color, color2, color == null);
    }

    public void createJPEG(int n, float f, String string, Color color, Color color2) {
        this.createImage("jpeg", n, f, string, color, color2, false);
    }

    public static Image createBufferedImage(String string, int n, float f, Color color, Color color2) throws ParseException {
        TeXFormula teXFormula = new TeXFormula(string);
        TeXIcon teXIcon = teXFormula.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(2, 2, 2, 2));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, color2 == null ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color == null ? Color.BLACK : color);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Image createBufferedImage(int n, float f, Color color, Color color2) throws ParseException {
        TeXIcon teXIcon = this.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(2, 2, 2, 2));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, color2 == null ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color == null ? Color.BLACK : color);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setDEBUG(boolean bl) {
        Box.DEBUG = bl;
    }

    public TeXFormula setBackground(Color color) {
        if (color != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(color, null, (ColorAtom)this.root) : new ColorAtom(this.root, color, null);
        }
        return this;
    }

    public TeXFormula setColor(Color color) {
        if (color != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(null, color, (ColorAtom)this.root) : new ColorAtom(this.root, null, color);
        }
        return this;
    }

    public TeXFormula setFixedTypes(int n, int n2) throws InvalidAtomTypeException {
        this.root = new TypedAtom(n, n2, this.root);
        return this;
    }

    public static TeXFormula get(String string) throws FormulaNotFoundException {
        TeXFormula teXFormula = predefinedTeXFormulas.get(string);
        if (teXFormula == null) {
            String string2 = predefinedTeXFormulasAsString.get(string);
            if (string2 == null) {
                throw new FormulaNotFoundException(string);
            }
            TeXFormula teXFormula2 = new TeXFormula(string2);
            predefinedTeXFormulas.put(string, teXFormula2);
            return teXFormula2;
        }
        return new TeXFormula(teXFormula);
    }

    static {
        TeXFormulaSettingsParser teXFormulaSettingsParser = new TeXFormulaSettingsParser();
        teXFormulaSettingsParser.parseSymbolMappings(symbolMappings, symbolTextMappings);
        new PredefinedCommands();
        new PredefinedTeXFormulas();
        new PredefMacros();
        teXFormulaSettingsParser.parseSymbolToFormulaMappings(symbolFormulaMappings, symbolTextMappings);
        try {
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration").newInstance());
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.greek.GreekRegistration").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class FontInfos {
        String sansserif;
        String serif;

        FontInfos(String string, String string2) {
            this.sansserif = string;
            this.serif = string2;
        }
    }

    public class TeXIconBuilder {
        private Integer style;
        private Float size;
        private Integer type;
        private Color fgcolor;
        private boolean trueValues = false;
        private Integer widthUnit;
        private Float textWidth;
        private Integer align;
        private boolean isMaxWidth = false;
        private Integer interLineUnit;
        private Float interLineSpacing;

        public TeXIconBuilder setStyle(int n) {
            this.style = n;
            return this;
        }

        public TeXIconBuilder setSize(float f) {
            this.size = Float.valueOf(f);
            return this;
        }

        public TeXIconBuilder setType(int n) {
            this.type = n;
            return this;
        }

        public TeXIconBuilder setFGColor(Color color) {
            this.fgcolor = color;
            return this;
        }

        public TeXIconBuilder setTrueValues(boolean bl) {
            this.trueValues = bl;
            return this;
        }

        public TeXIconBuilder setWidth(int n, float f, int n2) {
            this.widthUnit = n;
            this.textWidth = Float.valueOf(f);
            this.align = n2;
            this.trueValues = true;
            return this;
        }

        public TeXIconBuilder setIsMaxWidth(boolean bl) {
            if (this.widthUnit == null) {
                throw new IllegalStateException("Cannot set 'isMaxWidth' without having specified a width!");
            }
            if (bl) {
                this.align = 0;
            }
            this.isMaxWidth = bl;
            return this;
        }

        public TeXIconBuilder setInterLineSpacing(int n, float f) {
            if (this.widthUnit == null) {
                throw new IllegalStateException("Cannot set inter line spacing without having specified a width!");
            }
            this.interLineUnit = n;
            this.interLineSpacing = Float.valueOf(f);
            return this;
        }

        public TeXIcon build() {
            TeXIcon teXIcon;
            if (this.style == null) {
                throw new IllegalStateException("A style is required. Use setStyle()");
            }
            if (this.size == null) {
                throw new IllegalStateException("A size is required. Use setStyle()");
            }
            DefaultTeXFont defaultTeXFont = this.type == null ? new DefaultTeXFont(this.size.floatValue()) : TeXFormula.this.createFont(this.size.floatValue(), this.type);
            TeXEnvironment teXEnvironment = this.widthUnit != null ? new TeXEnvironment((int)this.style, (TeXFont)defaultTeXFont, this.widthUnit, this.textWidth.floatValue()) : new TeXEnvironment(this.style, defaultTeXFont);
            if (this.interLineUnit != null) {
                teXEnvironment.setInterline(this.interLineUnit, this.interLineSpacing.floatValue());
            }
            Box box = TeXFormula.this.createBox(teXEnvironment);
            if (this.widthUnit != null) {
                HorizontalBox horizontalBox;
                if (this.interLineUnit != null) {
                    float f = this.interLineSpacing.floatValue() * SpaceAtom.getFactor(this.interLineUnit, teXEnvironment);
                    Box box2 = BreakFormula.split(box, teXEnvironment.getTextwidth(), f);
                    horizontalBox = new HorizontalBox(box2, this.isMaxWidth ? box2.getWidth() : teXEnvironment.getTextwidth(), this.align);
                } else {
                    horizontalBox = new HorizontalBox(box, this.isMaxWidth ? box.getWidth() : teXEnvironment.getTextwidth(), this.align);
                }
                teXIcon = new TeXIcon(horizontalBox, this.size.floatValue(), this.trueValues);
            } else {
                teXIcon = new TeXIcon(box, this.size.floatValue(), this.trueValues);
            }
            if (this.fgcolor != null) {
                teXIcon.setForeground(this.fgcolor);
            }
            teXIcon.isColored = teXEnvironment.isColored;
            return teXIcon;
        }
    }
}

