/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeXSymbolParser {
    public static final String RESOURCE_NAME = "TeXSymbols.xml";
    public static final String DELIMITER_ATTR = "del";
    public static final String TYPE_ATTR = "type";
    private static Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private Element root;

    public TeXSymbolParser() throws ResourceParseException {
        this(TeXSymbolParser.class.getResourceAsStream(RESOURCE_NAME), RESOURCE_NAME);
    }

    public TeXSymbolParser(InputStream inputStream, String string) throws ResourceParseException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            this.root = documentBuilderFactory.newDocumentBuilder().parse(inputStream).getDocumentElement();
            this.setTypeMappings();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    public Map<String, SymbolAtom> readSymbols() throws ResourceParseException {
        HashMap<String, SymbolAtom> hashMap = new HashMap<String, SymbolAtom>();
        NodeList nodeList = this.root.getElementsByTagName("Symbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXSymbolParser.getAttrValueAndCheckIfNotNull("name", element);
            String string2 = TeXSymbolParser.getAttrValueAndCheckIfNotNull(TYPE_ATTR, element);
            String string3 = element.getAttribute(DELIMITER_ATTR);
            boolean bl = string3 != null && string3.equals("true");
            Integer n = typeMappings.get(string2);
            if (n == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "Symbol", TYPE_ATTR, "has an unknown value '" + string2 + "'!");
            }
            hashMap.put(string, new SymbolAtom(string, n, bl));
        }
        return hashMap;
    }

    private void setTypeMappings() {
        typeMappings.put("ord", 0);
        typeMappings.put("op", 1);
        typeMappings.put("bin", 2);
        typeMappings.put("rel", 3);
        typeMappings.put("open", 4);
        typeMappings.put("close", 5);
        typeMappings.put("punct", 6);
        typeMappings.put("acc", 10);
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, null);
        }
        return string2;
    }
}

