/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExternalResource
implements ExternalResource {
    protected abstract InputStream openStream() throws IOException;

    private InputStream openBuffered() {
        try {
            return new BufferedInputStream(this.openStream());
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(this.getURI(), String.format("Could not get resource '%s' as it does not exist.", this.getURI()), e);
        }
        catch (IOException e) {
            throw ResourceException.getFailed(this.getURI(), e);
        }
    }

    private void close(InputStream input) {
        try {
            input.close();
        }
        catch (IOException e) {
            throw ResourceException.getFailed(this.getURI(), e);
        }
    }

    @Override
    public String getName() {
        return this.getURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File destination) {
        try {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                this.writeTo(output);
            }
            finally {
                output.close();
            }
        }
        catch (Exception e) {
            throw ResourceException.getFailed(this.getURI(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream output) {
        try {
            InputStream input = this.openStream();
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            throw ResourceException.getFailed(this.getURI(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withContent(Action<? super InputStream> readAction) {
        InputStream input = this.openBuffered();
        try {
            readAction.execute((Object)input);
        }
        finally {
            this.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withContent(Transformer<? extends T, ? super InputStream> readAction) {
        InputStream input = this.openBuffered();
        try {
            Object object = readAction.transform((Object)input);
            return (T)object;
        }
        finally {
            this.close(input);
        }
    }

    @Override
    public <T> T withContent(ExternalResource.ContentAction<? extends T> readAction) {
        InputStream input = this.openBuffered();
        try {
            T t = readAction.execute(input, this.getMetaData());
            return t;
        }
        catch (IOException e) {
            throw ResourceException.getFailed(this.getURI(), e);
        }
        finally {
            this.close(input);
        }
    }

    @Override
    public void close() {
    }
}

