/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectChecker {
    public static final byte[] tree = Constants.encodeASCII("tree ");
    public static final byte[] parent = Constants.encodeASCII("parent ");
    public static final byte[] author = Constants.encodeASCII("author ");
    public static final byte[] committer = Constants.encodeASCII("committer ");
    public static final byte[] encoding = Constants.encodeASCII("encoding ");
    public static final byte[] object = Constants.encodeASCII("object ");
    public static final byte[] type = Constants.encodeASCII("type ");
    public static final byte[] tag = Constants.encodeASCII("tag ");
    public static final byte[] tagger = Constants.encodeASCII("tagger ");
    private final MutableObjectId tempId = new MutableObjectId();
    private final MutableInteger ptrout = new MutableInteger();
    private boolean allowZeroMode;
    private boolean windows;
    private boolean macosx;

    public ObjectChecker setAllowLeadingZeroFileMode(boolean allow) {
        this.allowZeroMode = allow;
        return this;
    }

    public ObjectChecker setSafeForWindows(boolean win) {
        this.windows = win;
        return this;
    }

    public ObjectChecker setSafeForMacOS(boolean mac) {
        this.macosx = mac;
        return this;
    }

    public void check(int objType, byte[] raw) throws CorruptObjectException {
        switch (objType) {
            case 1: {
                this.checkCommit(raw);
                break;
            }
            case 4: {
                this.checkTag(raw);
                break;
            }
            case 2: {
                this.checkTree(raw);
                break;
            }
            case 3: {
                this.checkBlob(raw);
                break;
            }
            default: {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidType2, objType));
            }
        }
    }

    private int id(byte[] raw, int ptr) {
        try {
            this.tempId.fromString(raw, ptr);
            return ptr + 40;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private int personIdent(byte[] raw, int ptr) {
        int emailB = RawParseUtils.nextLF(raw, ptr, '<');
        if (emailB == ptr || raw[emailB - 1] != 60) {
            return -1;
        }
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailE == emailB || raw[emailE - 1] != 62) {
            return -1;
        }
        if (emailE == raw.length || raw[emailE] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, emailE + 1, this.ptrout);
        ptr = this.ptrout.value;
        if (emailE + 1 == ptr) {
            return -1;
        }
        if (ptr == raw.length || raw[ptr] != 32) {
            return -1;
        }
        RawParseUtils.parseBase10(raw, ptr + 1, this.ptrout);
        if (ptr + 1 == this.ptrout.value) {
            return -1;
        }
        return this.ptrout.value;
    }

    public void checkCommit(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, tree)) < 0) {
            throw new CorruptObjectException("no tree header");
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid tree");
        }
        while (RawParseUtils.match(raw, ptr, parent) >= 0) {
            ptr += parent.length;
            if ((ptr = this.id(raw, ptr)) >= 0 && raw[ptr++] == 10) continue;
            throw new CorruptObjectException("invalid parent");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, author)) < 0) {
            throw new CorruptObjectException("no author");
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid author");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, committer)) < 0) {
            throw new CorruptObjectException("no committer");
        }
        if ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid committer");
        }
    }

    public void checkTag(byte[] raw) throws CorruptObjectException {
        int ptr = 0;
        if ((ptr = RawParseUtils.match(raw, ptr, object)) < 0) {
            throw new CorruptObjectException("no object header");
        }
        if ((ptr = this.id(raw, ptr)) < 0 || raw[ptr++] != 10) {
            throw new CorruptObjectException("invalid object");
        }
        if ((ptr = RawParseUtils.match(raw, ptr, type)) < 0) {
            throw new CorruptObjectException("no type header");
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tag)) < 0) {
            throw new CorruptObjectException("no tag header");
        }
        ptr = RawParseUtils.nextLF(raw, ptr);
        if ((ptr = RawParseUtils.match(raw, ptr, tagger)) > 0 && ((ptr = this.personIdent(raw, ptr)) < 0 || raw[ptr++] != 10)) {
            throw new CorruptObjectException("invalid tagger");
        }
    }

    private static int lastPathChar(int mode) {
        return FileMode.TREE.equals(mode) ? 47 : 0;
    }

    private static int pathCompare(byte[] raw, int aPos, int aEnd, int aMode, int bPos, int bEnd, int bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (raw[aPos++] & 0xFF) - (raw[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (raw[aPos] & 0xFF) - ObjectChecker.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return ObjectChecker.lastPathChar(aMode) - (raw[bPos] & 0xFF);
        }
        return 0;
    }

    private static boolean duplicateName(byte[] raw, int thisNamePos, int thisNameEnd) {
        int sz = raw.length;
        int nextPtr = thisNameEnd + 1 + 20;
        while (true) {
            byte c;
            int nextMode = 0;
            while (true) {
                byte c2;
                if (nextPtr >= sz) {
                    return false;
                }
                if (32 == (c2 = raw[nextPtr++])) break;
                nextMode <<= 3;
                nextMode += c2 - 48;
            }
            int nextNamePos = nextPtr;
            do {
                if (nextPtr != sz) continue;
                return false;
            } while ((c = raw[nextPtr++]) != 0);
            if (nextNamePos + 1 == nextPtr) {
                return false;
            }
            int cmp = ObjectChecker.pathCompare(raw, thisNamePos, thisNameEnd, FileMode.TREE.getBits(), nextNamePos, nextPtr - 1, nextMode);
            if (cmp < 0) {
                return false;
            }
            if (cmp == 0) {
                return true;
            }
            nextPtr += 20;
        }
    }

    public void checkTree(byte[] raw) throws CorruptObjectException {
        HashSet<String> normalized;
        int sz = raw.length;
        int ptr = 0;
        int lastNameB = 0;
        int lastNameE = 0;
        int lastMode = 0;
        HashSet<String> hashSet = normalized = this.windows || this.macosx ? new HashSet<String>() : null;
        while (ptr < sz) {
            int cmp;
            int thisMode = 0;
            while (true) {
                byte c;
                if (ptr == sz) {
                    throw new CorruptObjectException("truncated in mode");
                }
                if (32 == (c = raw[ptr++])) break;
                if (c < 48 || c > 55) {
                    throw new CorruptObjectException("invalid mode character");
                }
                if (thisMode == 0 && c == 48 && !this.allowZeroMode) {
                    throw new CorruptObjectException("mode starts with '0'");
                }
                thisMode <<= 3;
                thisMode += c - 48;
            }
            if (FileMode.fromBits(thisMode).getObjectType() == -1) {
                throw new CorruptObjectException("invalid mode " + thisMode);
            }
            int thisNameB = ptr;
            if ((ptr = this.scanPathSegment(raw, ptr, sz)) == sz || raw[ptr] != 0) {
                throw new CorruptObjectException("truncated in name");
            }
            this.checkPathSegment2(raw, thisNameB, ptr);
            if (normalized != null ? !normalized.add(this.normalize(raw, thisNameB, ptr)) : ObjectChecker.duplicateName(raw, thisNameB, ptr)) {
                throw new CorruptObjectException("duplicate entry names");
            }
            if (lastNameB != 0 && (cmp = ObjectChecker.pathCompare(raw, lastNameB, lastNameE, lastMode, thisNameB, ptr, thisMode)) > 0) {
                throw new CorruptObjectException("incorrectly sorted");
            }
            lastNameB = thisNameB;
            lastNameE = ptr;
            lastMode = thisMode;
            if ((ptr += 21) <= sz) continue;
            throw new CorruptObjectException("truncated in object id");
        }
    }

    private int scanPathSegment(byte[] raw, int ptr, int end) throws CorruptObjectException {
        while (ptr < end) {
            byte c = raw[ptr];
            if (c == 0) {
                return ptr;
            }
            if (c == 47) {
                throw new CorruptObjectException("name contains '/'");
            }
            if (this.windows && ObjectChecker.isInvalidOnWindows(c)) {
                if (c > 31) {
                    throw new CorruptObjectException(String.format("name contains '%c'", c));
                }
                throw new CorruptObjectException(String.format("name contains byte 0x%x", c & 0xFF));
            }
            ++ptr;
        }
        return ptr;
    }

    public void checkPathSegment(byte[] raw, int ptr, int end) throws CorruptObjectException {
        int e = this.scanPathSegment(raw, ptr, end);
        if (e < end && raw[e] == 0) {
            throw new CorruptObjectException("name contains byte 0x00");
        }
        this.checkPathSegment2(raw, ptr, end);
    }

    private void checkPathSegment2(byte[] raw, int ptr, int end) throws CorruptObjectException {
        if (ptr == end) {
            throw new CorruptObjectException("zero length name");
        }
        if (raw[ptr] == 46) {
            switch (end - ptr) {
                case 1: {
                    throw new CorruptObjectException("invalid name '.'");
                }
                case 2: {
                    if (raw[ptr + 1] != 46) break;
                    throw new CorruptObjectException("invalid name '..'");
                }
                case 4: {
                    if (!this.isDotGit(raw, ptr + 1)) break;
                    throw new CorruptObjectException(String.format("invalid name '%s'", RawParseUtils.decode(raw, ptr, end)));
                }
            }
        }
        if (this.windows) {
            if (raw[end - 1] == 32 || raw[end - 1] == 46) {
                throw new CorruptObjectException("invalid name ends with '" + (char)raw[end - 1] + "'");
            }
            if (end - ptr >= 3) {
                ObjectChecker.checkNotWindowsDevice(raw, ptr, end);
            }
        }
    }

    private static void checkNotWindowsDevice(byte[] raw, int ptr, int end) throws CorruptObjectException {
        switch (ObjectChecker.toLower(raw[ptr])) {
            case 'a': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'x' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException("invalid name 'AUX'");
            }
            case 'c': {
                if (end - ptr >= 3 && ObjectChecker.toLower(raw[ptr + 2]) == 'n' && ObjectChecker.toLower(raw[ptr + 1]) == 'o' && (end - ptr == 3 || raw[ptr + 3] == 46)) {
                    throw new CorruptObjectException("invalid name 'CON'");
                }
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 2]) != 'm' || ObjectChecker.toLower(raw[ptr + 1]) != 'o' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                throw new CorruptObjectException("invalid name 'COM" + (char)raw[ptr + 3] + "'");
            }
            case 'l': {
                if (end - ptr < 4 || ObjectChecker.toLower(raw[ptr + 1]) != 'p' || ObjectChecker.toLower(raw[ptr + 2]) != 't' || !ObjectChecker.isPositiveDigit(raw[ptr + 3]) || end - ptr != 4 && raw[ptr + 4] != 46) break;
                throw new CorruptObjectException("invalid name 'LPT" + (char)raw[ptr + 3] + "'");
            }
            case 'n': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'u' || ObjectChecker.toLower(raw[ptr + 2]) != 'l' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException("invalid name 'NUL'");
            }
            case 'p': {
                if (end - ptr < 3 || ObjectChecker.toLower(raw[ptr + 1]) != 'r' || ObjectChecker.toLower(raw[ptr + 2]) != 'n' || end - ptr != 3 && raw[ptr + 3] != 46) break;
                throw new CorruptObjectException("invalid name 'PRN'");
            }
        }
    }

    private static boolean isInvalidOnWindows(byte c) {
        switch (c) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 124: {
                return true;
            }
        }
        return 1 <= c && c <= 31;
    }

    private boolean isDotGit(byte[] buf, int p) {
        if (this.windows || this.macosx) {
            return ObjectChecker.toLower(buf[p]) == 'g' && ObjectChecker.toLower(buf[p + 1]) == 'i' && ObjectChecker.toLower(buf[p + 2]) == 't';
        }
        return buf[p] == 103 && buf[p + 1] == 105 && buf[p + 2] == 116;
    }

    private static char toLower(byte b) {
        if (65 <= b && b <= 90) {
            return (char)(b + 32);
        }
        return (char)b;
    }

    private static boolean isPositiveDigit(byte b) {
        return 49 <= b && b <= 57;
    }

    public void checkBlob(byte[] raw) throws CorruptObjectException {
    }

    private String normalize(byte[] raw, int ptr, int end) {
        String n = RawParseUtils.decode(raw, ptr, end).toLowerCase(Locale.US);
        return this.macosx ? Normalizer.normalize(n) : n;
    }

    private static class Normalizer {
        private static final Method normalize;
        private static final Object nfc;

        private Normalizer() {
        }

        static String normalize(String in) {
            if (normalize == null) {
                return in;
            }
            try {
                return (String)normalize.invoke(null, in, nfc);
            }
            catch (IllegalAccessException e) {
                return in;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                return in;
            }
        }

        static {
            Method method;
            Object formNfc;
            try {
                Class<?> formClazz = Class.forName("java.text.Normalizer$Form");
                formNfc = formClazz.getField("NFC").get(null);
                method = Class.forName("java.text.Normalizer").getMethod("normalize", CharSequence.class, formClazz);
            }
            catch (ClassNotFoundException e) {
                method = null;
                formNfc = null;
            }
            catch (NoSuchFieldException e) {
                method = null;
                formNfc = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
                formNfc = null;
            }
            catch (SecurityException e) {
                method = null;
                formNfc = null;
            }
            catch (IllegalArgumentException e) {
                method = null;
                formNfc = null;
            }
            catch (IllegalAccessException e) {
                method = null;
                formNfc = null;
            }
            normalize = method;
            nfc = formNfc;
        }
    }
}

