
# Macros cmake's CONFIGURE_PACKAGE_CONFIG_FILE() would create

macro(set_and_check _var _file)
set(${_var} "${_file}")
if(NOT EXISTS "${_file}")
  message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
  endmacro()

  macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
  if(NOT ${_NAME}_${comp}_FOUND)
    if(${_NAME}_FIND_REQUIRED_${comp})
      set(${_NAME}_FOUND FALSE)
      endif()
      endif()
      endforeach()
      endmacro()

      set_and_check(prefix "/usr")
      set_and_check(exec_prefix "${prefix}")
      set_and_check(includedir "${prefix}/include")
      set_and_check(GWENGUI_QT4_INCLUDE_DIRS "${includedir}/gwenhywfar4")
      set_and_check(GWENGUI_QT4_LIBRARIES "${exec_prefix}/lib/libgwengui-qt4.so")
      set_and_check(GWENHYWFAR_CPP_LIBRARIES "${exec_prefix}/lib/libgwengui-cpp.so")

      set(GWENGUI_QT4_LIBRARIES ${GWENGUI_QT4_LIBRARIES} ${GWENHYWFAR_CPP_LIBRARIES})

      mark_as_advanced( GWENGUI_QT4_INCLUDE_DIRS GWENGUI_QT4_LIBRARIES GWENHYWFAR_CPP_LIBRARIES)
