/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptorImpl;
import org.jetbrains.annotations.Nullable;

public class ExecutionInfo {
    @Nullable
    private final String myId;
    @Nullable
    private String myWorkingDir;
    private OperationDescriptor myDescriptor;
    private long startTime;
    private long endTime;
    private boolean isFailed;
    private boolean isSkipped;
    private boolean isUpToDate;

    public ExecutionInfo(@Nullable String id, OperationDescriptor descriptor, @Nullable String workingDir) {
        this.myId = id;
        this.myWorkingDir = workingDir;
        this.myDescriptor = descriptor;
    }

    public ExecutionInfo(String id, String description, @Nullable String workingDir) {
        this(id, (OperationDescriptor)new OperationDescriptorImpl(description, -1L), workingDir);
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    @Nullable
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public void setWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
    }

    public String getDisplayName() {
        return this.myDescriptor.getDisplayName();
    }

    public OperationDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public void setDescriptor(OperationDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public void setFailed(boolean failed) {
        this.isFailed = failed;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setSkipped(boolean skipped) {
        this.isSkipped = skipped;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public void setUpToDate(boolean upToDate) {
        this.isUpToDate = upToDate;
    }

    public boolean isRunning() {
        return this.endTime <= 0L && !this.isSkipped && !this.isFailed;
    }

    public String toString() {
        return this.myDescriptor.getDisplayName();
    }
}

