/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.impl.WrongNameFormatException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class ExecuteCompositeTargetEvent
extends ExecutionEvent {
    @NonNls
    public static final String TYPE_ID = "compositeTask";
    private final String myCompositeName;
    private String myPresentableName;
    private final String[] myTargetNames;
    @NonNls
    public static final String PRESENTABLE_NAME = "presentableName";

    public ExecuteCompositeTargetEvent(String compositeName) throws WrongNameFormatException {
        if (!compositeName.startsWith("[") || !compositeName.endsWith("]") || compositeName.length() <= 2) {
            throw new WrongNameFormatException(compositeName);
        }
        this.myCompositeName = compositeName;
        StringTokenizer tokenizer = new StringTokenizer(compositeName.substring(1, compositeName.length() - 1), ",", false);
        ArrayList<String> targetNames = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            targetNames.add(tokenizer.nextToken().trim());
        }
        this.myTargetNames = ArrayUtil.toStringArray(targetNames);
        this.myPresentableName = compositeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteCompositeTargetEvent(String[] targetNames) {
        this.myTargetNames = targetNames;
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("[");
            for (int idx = 0; idx < targetNames.length; ++idx) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append(targetNames[idx]);
            }
            builder.append("]");
            this.myCompositeName = builder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
        this.myPresentableName = this.myCompositeName;
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public String getPresentableName() {
        return this.myPresentableName;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public String getMetaTargetName() {
        return this.myCompositeName;
    }

    public String[] getTargetNames() {
        return this.myTargetNames;
    }

    @Override
    public void readExternal(Element element, Project project) throws InvalidDataException {
        super.readExternal(element, project);
        this.myPresentableName = element.getAttributeValue(PRESENTABLE_NAME);
    }

    @Override
    public String writeExternal(Element element, Project project) {
        element.setAttribute(PRESENTABLE_NAME, this.myPresentableName);
        return this.myCompositeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteCompositeTargetEvent event = (ExecuteCompositeTargetEvent)o;
        return this.myCompositeName.equals(event.myCompositeName);
    }

    public int hashCode() {
        return this.myCompositeName.hashCode();
    }
}

