/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.SystemImage;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgType;
import com.google.common.base.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemImageDescription {
    private IAndroidTarget myTarget;
    private ISystemImage mySystemImage;
    private IPkgDesc myRemotePackage;

    public SystemImageDescription(IAndroidTarget target, ISystemImage systemImage) {
        this.myTarget = target;
        this.mySystemImage = systemImage;
    }

    public SystemImageDescription(IPkgDesc remotePackage, IAndroidTarget target) {
        this.myRemotePackage = remotePackage;
        this.myTarget = target;
    }

    static boolean hasSystemImage(IPkgDesc desc) {
        if (desc.getType().equals((Object)PkgType.PKG_SYS_IMAGE) || desc.getType().equals((Object)PkgType.PKG_ADDON_SYS_IMAGE)) {
            return true;
        }
        if (desc.getType().equals((Object)PkgType.PKG_PLATFORM) && desc.getAndroidVersion().getApiLevel() <= 13) {
            return true;
        }
        return desc.getType().equals((Object)PkgType.PKG_ADDON) && desc.hasVendor() && desc.getVendor().getId().equals("google") && ((IPkgDescAddon)desc).getName().getId().equals("google_apis") && desc.getAndroidVersion().getApiLevel() <= 18;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myTarget, this.mySystemImage, this.myRemotePackage});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemImageDescription)) {
            return false;
        }
        SystemImageDescription other = (SystemImageDescription)obj;
        return Objects.equal((Object)this.myTarget, (Object)other.myTarget) && Objects.equal((Object)this.mySystemImage, (Object)other.mySystemImage) && Objects.equal((Object)this.myRemotePackage, (Object)other.myRemotePackage);
    }

    @Nullable
    public AndroidVersion getVersion() {
        if (this.myTarget != null) {
            return this.myTarget.getVersion();
        }
        if (this.myRemotePackage != null) {
            return this.myRemotePackage.getAndroidVersion();
        }
        return null;
    }

    public IPkgDesc getRemotePackage() {
        return this.myRemotePackage;
    }

    public boolean isRemote() {
        return this.myRemotePackage != null;
    }

    @NotNull
    public String getAbiType() {
        if (this.mySystemImage != null) {
            String string = this.mySystemImage.getAbiType();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getAbiType"));
            }
            return string;
        }
        PkgType type = this.myRemotePackage.getType();
        if (type == PkgType.PKG_SYS_IMAGE || type == PkgType.PKG_ADDON_SYS_IMAGE) {
            String string = this.myRemotePackage.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getAbiType"));
            }
            return string;
        }
        if (type == PkgType.PKG_PLATFORM || type == PkgType.PKG_ADDON) {
            if ("armeabi" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getAbiType"));
            }
            return "armeabi";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getAbiType"));
        }
        return "";
    }

    @NotNull
    public IdDisplay getTag() {
        if (this.mySystemImage != null) {
            IdDisplay idDisplay = this.mySystemImage.getTag();
            if (idDisplay == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getTag"));
            }
            return idDisplay;
        }
        if (this.myRemotePackage.getType() == PkgType.PKG_ADDON) {
            IdDisplay idDisplay = ((IPkgDescAddon)this.myRemotePackage).getName();
            if (idDisplay == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getTag"));
            }
            return idDisplay;
        }
        IdDisplay tag = this.myRemotePackage.getTag();
        if (tag != null) {
            IdDisplay idDisplay = tag;
            if (idDisplay == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getTag"));
            }
            return idDisplay;
        }
        IdDisplay idDisplay = SystemImage.DEFAULT_TAG;
        if (idDisplay == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/SystemImageDescription", "getTag"));
        }
        return idDisplay;
    }

    public String getName() {
        if (this.getVersion() != null) {
            return String.format("Android %s", SdkVersionInfo.getVersionString((int)this.getVersion().getFeatureLevel()));
        }
        return "Unknown platform";
    }

    public String getVendor() {
        IdDisplay vendor;
        if (this.myTarget != null) {
            return this.myTarget.getVendor();
        }
        if (this.mySystemImage != null && this.mySystemImage.getAddonVendor() != null) {
            return this.mySystemImage.getAddonVendor().getDisplay();
        }
        if (this.myRemotePackage != null && (vendor = this.myRemotePackage.getVendor()) != null) {
            return vendor.getDisplay();
        }
        return "";
    }

    public String getVersionName() {
        if (this.myTarget != null) {
            return this.myTarget.getVersionName();
        }
        return "";
    }

    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public File[] getSkins() {
        if (this.myTarget != null) {
            return this.myTarget.getSkins();
        }
        return new File[0];
    }
}

