/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageCellController;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.widgets.CellList;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrubberController
extends ImageCellController<Data> {
    private static final Dimension PREVIEW_SIZE = JBUI.size((int)192, (int)192);
    @NotNull
    private static final Logger LOG = Logger.getInstance(ScrubberController.class);
    @NotNull
    private final PathStore<DevicePath> myRenderDevice;
    @NotNull
    private final PathStore<AtomsPath> myAtomsPath;
    @NotNull
    private final RenderSettings myRenderSettings;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new ScrubberController((GfxTraceEditor)editor).myList;
    }

    private ScrubberController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "<init>"));
        }
        super(editor);
        this.myRenderDevice = new PathStore();
        this.myAtomsPath = new PathStore();
        this.myRenderSettings = new RenderSettings();
        this.usingListWidget(CellList.Orientation.HORIZONTAL, "Loading capture...", PREVIEW_SIZE);
        this.myRenderSettings.setMaxWidth(ScrubberController.PREVIEW_SIZE.width);
        this.myRenderSettings.setMaxHeight(ScrubberController.PREVIEW_SIZE.height);
        this.myRenderSettings.setWireframeMode(WireframeMode.noWireframe());
    }

    @Override
    public void loadCell(final Data cell, final Runnable onLoad) {
        DevicePath devicePath = this.myRenderDevice.getPath();
        if (devicePath == null) {
            return;
        }
        final ServiceClient client = this.myEditor.getClient();
        ListenableFuture<ImageInfoPath> imagePathF = client.getFramebufferColor(devicePath, cell.atomPath, this.myRenderSettings);
        Futures.addCallback(imagePathF, (FutureCallback)new LoadingCallback<ImageInfoPath>(LOG, (LoadingCallback.LoadingDone)cell){

            public void onSuccess(@Nullable ImageInfoPath imagePath) {
                ScrubberController.this.loadCellImage(cell, client, imagePath, onLoad);
            }
        });
    }

    @Override
    public void selected(@NotNull Data cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "selected"));
        }
        if (this.myAtomsPath.getPath() == null) {
            return;
        }
        AtomPath atomPath = this.myAtomsPath.getPath().index(cell.range.getLast());
        this.myEditor.activatePath(atomPath, this);
    }

    @Nullable
    public List<Data> prepareData(@NotNull AtomsPath path, @NotNull AtomList atoms) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        if (atoms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atoms", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        ArrayList<Data> generatedList = new ArrayList<Data>();
        int frameCount = 0;
        Range range = new Range();
        range.setStart(0L);
        for (int index = 0; index < atoms.getAtoms().length; ++index) {
            Atom atom = atoms.get(index);
            if (!atom.isEndOfFrame()) continue;
            range.setEnd(index + 1);
            Data frameData = new Data(path.index(index), range, Integer.toString(frameCount++));
            generatedList.add(frameData);
            range = new Range();
            range.setStart(index + 1);
        }
        return generatedList;
    }

    private void selectFrame(AtomPath atomPath) {
        if (atomPath == null) {
            return;
        }
        int index = 0;
        for (Data data : this.myList.items()) {
            if (data.range.contains(atomPath.getIndex())) {
                this.myList.selectItem(index, false);
                break;
            }
            ++index;
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        boolean updateIcons = this.myRenderDevice.updateIfNotNull(event.findDevicePath());
        updateIcons = this.myAtomsPath.updateIfNotNull(CapturePath.atoms(event.findCapturePath())) | updateIcons;
        this.selectFrame(event.findAtomPath());
        final AtomsPath atomsPath = this.myAtomsPath.getPath();
        if (updateIcons && atomsPath != null) {
            Futures.addCallback(this.myEditor.getClient().get(atomsPath), (FutureCallback)new LoadingCallback<AtomList>(LOG){

                public void onSuccess(@Nullable AtomList atoms) {
                    ScrubberController.this.myList.setData(ScrubberController.this.prepareData(atomsPath, atoms));
                }
            }, (Executor)EdtExecutor.INSTANCE);
        }
    }

    public static class Data
    extends ImageCellList.Data {
        @NotNull
        public final AtomPath atomPath;
        @NotNull
        public final Range range;

        public Data(AtomPath atomPath, @NotNull Range range, @NotNull String label) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController$Data", "<init>"));
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController$Data", "<init>"));
            }
            super(label);
            this.atomPath = atomPath;
            this.range = range;
        }
    }
}

