/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GradleProjectBuilder {
    @NotNull
    private final Project myProject;

    @NotNull
    public static GradleProjectBuilder getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/GradleProjectBuilder", "getInstance"));
        }
        GradleProjectBuilder gradleProjectBuilder = (GradleProjectBuilder)ServiceManager.getService((Project)project, GradleProjectBuilder.class);
        if (gradleProjectBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/GradleProjectBuilder", "getInstance"));
        }
        return gradleProjectBuilder;
    }

    public GradleProjectBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/GradleProjectBuilder", "<init>"));
        }
        this.myProject = project;
    }

    public void assembleTranslate() {
        if (Projects.requiresAndroidModel(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).assembleTranslate();
                return;
            }
            this.buildProjectWithJps(BuildMode.ASSEMBLE_TRANSLATE);
        }
    }

    public void compileJava() {
        if (Projects.requiresAndroidModel(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                GradleInvoker.getInstance(this.myProject).compileJava(modules, GradleInvoker.TestCompileType.NONE);
                return;
            }
            this.buildProjectWithJps(BuildMode.COMPILE_JAVA);
        }
    }

    public void clean() {
        if (Projects.requiresAndroidModel(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).cleanProject();
                return;
            }
            this.buildProjectWithJps(BuildMode.CLEAN);
        }
    }

    public void generateSourcesOnly() {
        if (!this.isSourceGenerationEnabled()) {
            return;
        }
        if (Projects.requiresAndroidModel(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).generateSources();
            } else {
                this.buildProjectWithJps(BuildMode.SOURCE_GEN);
            }
        }
    }

    public boolean isSourceGenerationEnabled() {
        if (Projects.requiresAndroidModel(this.myProject)) {
            int moduleCount = ModuleManager.getInstance((Project)this.myProject).getModules().length;
            GradleExperimentalSettings settings = GradleExperimentalSettings.getInstance();
            return GradleProjectBuilder.isSourceGenerationEnabled(settings, moduleCount);
        }
        return false;
    }

    @VisibleForTesting
    @Contract(pure=true)
    static boolean isSourceGenerationEnabled(@NotNull GradleExperimentalSettings settings, int moduleCount) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/project/build/GradleProjectBuilder", "isSourceGenerationEnabled"));
        }
        return !settings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC && moduleCount <= settings.MAX_MODULE_COUNT_FOR_SOURCE_GEN;
    }

    private void buildProjectWithJps(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/project/build/GradleProjectBuilder", "buildProjectWithJps"));
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
        CompilerManager.getInstance((Project)this.myProject).make(null);
    }
}

