/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.builder.model.Variant;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.rendering.DynamicResourceValueItem;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements GradleSyncListener,
BuildVariantView.BuildVariantSelectionChangeListener {
    private final AndroidFacet myFacet;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> mItems;

    private DynamicResourceValueRepository(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "<init>"));
        }
        super("Gradle Dynamic");
        this.mItems = Maps.newEnumMap(ResourceType.class);
        this.myFacet = facet;
        assert (facet.requiresAndroidModel());
        facet.addListener(this);
        BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this);
    }

    @NotNull
    public static DynamicResourceValueRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "create"));
        }
        DynamicResourceValueRepository dynamicResourceValueRepository = new DynamicResourceValueRepository(facet);
        if (dynamicResourceValueRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "create"));
        }
        return dynamicResourceValueRepository;
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        if (this.mItems.isEmpty()) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel == null) {
                return this.mItems;
            }
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                this.addValues(buildType.getBuildType().getResValues());
            }
            this.addValues(selectedVariant.getMergedFlavor().getResValues());
        }
        return this.mItems;
    }

    private void notifyGradleSynced() {
        this.mItems.clear();
        super.invalidateItemCaches(new ResourceType[0]);
    }

    private void addValues(Map<String, ClassField> resValues) {
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField field = entry.getValue();
            String name = field.getName();
            assert (entry.getKey().equals(name)) : entry.getKey() + " vs " + name;
            ResourceType type = ResourceType.getEnum((String)field.getType());
            if (type == null) {
                LOG.warn("Ignoring field " + name + "(" + field + "): unknown type " + field.getType());
                continue;
            }
            ArrayListMultimap map = this.mItems.get(type);
            if (map == null) {
                map = ArrayListMultimap.create();
                this.mItems.put(type, (ListMultimap<String, ResourceItem>)map);
            } else if (map.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(type, field);
            map.put((Object)name, (Object)item);
        }
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap;
        if (this.mItems.isEmpty()) {
            this.getMap();
        }
        if ((multimap = this.mItems.get(type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.mItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "syncStarted"));
        }
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "syncSucceeded"));
        }
        this.notifyGradleSynced();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "syncFailed"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "syncFailed"));
        }
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/DynamicResourceValueRepository", "syncSkipped"));
        }
    }

    @Override
    public void buildVariantsConfigChanged() {
        this.notifyGradleSynced();
    }
}

