/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.rendering.ImageUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Gray;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final int MAX_WIDTH = JBUI.scale((int)16);
    private static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final Icon NONE = AndroidIcons.Android;
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private boolean myRetina;
    private static boolean ourRetinaEnabled = true;

    @NotNull
    public static GutterIconCache getInstance() {
        GutterIconCache gutterIconCache = ourInstance;
        if (gutterIconCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/GutterIconCache", "getInstance"));
        }
        return gutterIconCache;
    }

    @Nullable
    public Icon getIcon(@NotNull String path) {
        Icon myIcon;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/rendering/GutterIconCache", "getIcon"));
        }
        boolean isRetina = UIUtil.isRetina();
        if (this.myRetina != isRetina) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path)) == null) {
            myIcon = GutterIconCache.createIcon(path);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path, myIcon);
        }
        return myIcon != NONE ? myIcon : null;
    }

    @Nullable
    private static Icon createIcon(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/rendering/GutterIconCache", "createIcon"));
        }
        if (path.endsWith(".xml")) {
            return GutterIconCache.createXmlIcon(path);
        }
        return GutterIconCache.createBitmapIcon(path);
    }

    @Nullable
    private static Icon createXmlIcon(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/rendering/GutterIconCache", "createXmlIcon"));
        }
        try {
            String xml = Files.toString((File)new File(path), (Charset)Charsets.UTF_8);
            if (xml.contains("<vector")) {
                StringBuilder builder = new StringBuilder();
                boolean isRetina = ourRetinaEnabled && UIUtil.isRetina();
                VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)(isRetina ? 2 * MAX_WIDTH : MAX_WIDTH));
                BufferedImage image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xml, (StringBuilder)builder);
                if (builder.length() > 0) {
                    LOG.warn("Problems rendering " + path + ": " + builder);
                }
                if (image != null) {
                    if (isRetina) {
                        int scale = 2;
                        if (image.getWidth() >= 2 && image.getHeight() >= 2) {
                            try {
                                Image hdpiImage = RetinaImage.createFrom((Image)image, (int)2, null);
                                return new RetinaImageIcon(hdpiImage);
                            }
                            catch (Throwable t) {
                                ourRetinaEnabled = false;
                            }
                        }
                    }
                    return new ImageIcon(image);
                }
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read/render icon image %1$s", path), e);
        }
        return null;
    }

    @Nullable
    private static Icon createBitmapIcon(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/rendering/GutterIconCache", "createBitmapIcon"));
        }
        try {
            BufferedImage image = ImageIO.read(new File(path));
            if (image != null) {
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                if (ourRetinaEnabled && UIUtil.isRetina()) {
                    BufferedImage scaled = image;
                    if (imageWidth > 2 * MAX_WIDTH || imageHeight > 2 * MAX_HEIGHT) {
                        double scale = 2.0 * Math.min((double)MAX_WIDTH / (double)imageWidth, (double)MAX_HEIGHT / (double)imageHeight);
                        scaled = ImageUtils.scale(image, scale, scale);
                    }
                    int scale = 2;
                    if (scaled.getWidth() >= 2 && scaled.getHeight() >= 2) {
                        try {
                            Image hdpiImage = RetinaImage.createFrom((Image)scaled, (int)2, null);
                            return new RetinaImageIcon(hdpiImage);
                        }
                        catch (Throwable t) {
                            ourRetinaEnabled = false;
                        }
                    }
                }
                if (imageWidth > MAX_WIDTH || imageHeight > MAX_HEIGHT) {
                    double scale = Math.min((double)MAX_WIDTH / (double)imageWidth, (double)MAX_HEIGHT / (double)imageHeight);
                    if (image.getType() == 13) {
                        BufferedImage bg = UIUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                        Graphics g = bg.getGraphics();
                        g.setColor(Gray.TRANSPARENT);
                        g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                        g.dispose();
                        image = bg;
                    }
                    image = ImageUtils.scale(image, scale, scale);
                }
                return new ImageIcon(image);
            }
        }
        catch (IOException e) {
            LOG.warn(String.format("Could not read icon image %1$s", path), (Throwable)e);
        }
        return null;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

