/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class LaunchCompatibiltyChecker {
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;

    public LaunchCompatibiltyChecker(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget target, @NotNull EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSdkVersion", "com/android/tools/idea/run/LaunchCompatibiltyChecker", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/LaunchCompatibiltyChecker", "<init>"));
        }
        if (requiredHardwareFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredHardwareFeatures", "com/android/tools/idea/run/LaunchCompatibiltyChecker", "<init>"));
        }
        this.myMinSdkVersion = minSdkVersion;
        this.myProjectTarget = target;
        this.myRequiredHardwareFeatures = requiredHardwareFeatures;
    }

    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/LaunchCompatibiltyChecker", "validate"));
        }
        return LaunchCompatibility.canRunOnDevice(this.myMinSdkVersion, this.myProjectTarget, this.myRequiredHardwareFeatures, device, null);
    }
}

