/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.tools.idea.npw.ImportUIUtil;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.utils.ILogger;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ComponentInstaller myComponentInstaller;
    @NotNull
    private Collection<? extends InstallableComponent> myComponents;

    public InstallComponentsOperation(@NotNull InstallContext context, @NotNull Collection<? extends InstallableComponent> components, @NotNull ComponentInstaller componentInstaller, double progressRatio) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        if (componentInstaller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstaller", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "<init>"));
        }
        super(context, progressRatio);
        this.LOG = Logger.getInstance(this.getClass());
        this.myComponentInstaller = componentInstaller;
        this.myComponents = components;
    }

    @Nullable
    private static String getRetryMessage(Collection<String> packages) {
        if (!packages.isEmpty()) {
            return ImportUIUtil.formatElementListString(packages, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }
        return null;
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File sdkLocation) throws WizardException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        SdkManager manager = SdkManager.createManager((String)sdkLocation.getAbsolutePath(), (ILogger)new LogWrapper(this.LOG));
        if (manager != null) {
            indicator.setText("Checking for updated SDK components");
            ArrayList<String> packages = this.myComponentInstaller.getPackagesToInstall(manager, this.myComponents, true);
            while (!packages.isEmpty()) {
                SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext, packages.size());
                this.myComponentInstaller.installPackages(manager, packages, (ILogger)logger);
                manager.reloadSdk((ILogger)new LogWrapper(this.LOG));
                packages = this.myComponentInstaller.getPackagesToInstall(manager, this.myComponents, false);
                String message = InstallComponentsOperation.getRetryMessage(packages);
                if (message == null) continue;
                this.promptToRetry(message, logger.getErrors(), null);
            }
        } else {
            throw new WizardException("Corrupt SDK installation");
        }
        this.myContext.print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        File file = sdkLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "perform"));
        }
        return file;
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/install/InstallComponentsOperation", "cleanup"));
        }
    }
}

