/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;

    public IndexSearcher(String path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(Directory directory) throws CorruptIndexException, IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        TopDocCollector collector = new TopDocCollector(nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return collector.topDocs();
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        TopFieldDocCollector collector = new TopFieldDocCollector(this.reader, sort, nDocs);
        this.search(weight, filter, (HitCollector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    public void search(Weight weight, Filter filter, HitCollector results) throws IOException {
        boolean more;
        Scorer scorer = weight.scorer(this.reader);
        if (scorer == null) {
            return;
        }
        if (filter == null) {
            scorer.score(results);
            return;
        }
        DocIdSetIterator filterDocIdIterator = filter.getDocIdSet(this.reader).iterator();
        boolean bl = more = filterDocIdIterator.next() && scorer.skipTo(filterDocIdIterator.doc());
        while (more) {
            int filterDocId = filterDocIdIterator.doc();
            if (filterDocId > scorer.doc() && !scorer.skipTo(filterDocId)) {
                more = false;
                continue;
            }
            int scorerDocId = scorer.doc();
            if (scorerDocId == filterDocId) {
                results.collect(scorerDocId, scorer.score());
                more = filterDocIdIterator.next();
                continue;
            }
            more = filterDocIdIterator.skipTo(scorerDocId);
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        return weight.explain(this.reader, doc);
    }
}

