/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Filter {
    public static final Filter[] EMPTY_ARRAY = new Filter[0];

    @Nullable
    public Result applyFilter(String var1, int var2);

    public static class ResultItem {
        @Deprecated
        public final int highlightStartOffset;
        @Deprecated
        public final int highlightEndOffset;
        @Deprecated
        @Nullable
        public final TextAttributes highlightAttributes;
        @Deprecated
        @Nullable
        public final HyperlinkInfo hyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes) {
            this.highlightStartOffset = highlightStartOffset;
            this.highlightEndOffset = highlightEndOffset;
            this.hyperlinkInfo = hyperlinkInfo;
            this.highlightAttributes = highlightAttributes;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
        }

        public int getHighlightStartOffset() {
            return this.highlightStartOffset;
        }

        public int getHighlightEndOffset() {
            return this.highlightEndOffset;
        }

        @Nullable
        public TextAttributes getHighlightAttributes() {
            return this.highlightAttributes;
        }

        @Nullable
        public TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }

        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return this.hyperlinkInfo;
        }
    }

    public static enum NextAction {
        EXIT,
        CONTINUE_FILTERING;

    }

    public static class Result
    extends ResultItem {
        private static final Map<TextAttributesKey, TextAttributes> GRAYED_BY_NORMAL_CACHE = ContainerUtil.newConcurrentMap((int)2);
        protected NextAction myNextAction;
        protected final List<ResultItem> myResultItems;

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes, @Nullable TextAttributes followedHyperlinkAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes, followedHyperlinkAttributes);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, boolean grayedHyperlink) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, grayedHyperlink ? Result.getGrayedHyperlinkAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES) : null, grayedHyperlink ? Result.getGrayedHyperlinkAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES) : null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(@NotNull List<ResultItem> resultItems) {
            if (resultItems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultItems", "com/intellij/execution/filters/Filter$Result", "<init>"));
            }
            super(-1, -1, null, null, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = resultItems;
        }

        public List<ResultItem> getResultItems() {
            List<ResultItem> resultItems = this.myResultItems;
            if (resultItems == null) {
                resultItems = Collections.singletonList(this);
            }
            return resultItems;
        }

        @Override
        @Deprecated
        public int getHighlightStartOffset() {
            return super.getHighlightStartOffset();
        }

        @Override
        @Deprecated
        public int getHighlightEndOffset() {
            return super.getHighlightEndOffset();
        }

        @Override
        @Deprecated
        @Nullable
        public TextAttributes getHighlightAttributes() {
            return super.getHighlightAttributes();
        }

        @Override
        @Deprecated
        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return super.getHyperlinkInfo();
        }

        @Nullable
        public HyperlinkInfo getFirstHyperlinkInfo() {
            HyperlinkInfo info = super.getHyperlinkInfo();
            if (info == null && this.myResultItems != null) {
                for (int i = 0; i < this.myResultItems.size(); ++i) {
                    ResultItem resultItem = this.myResultItems.get(i);
                    if (resultItem.getHyperlinkInfo() == null) continue;
                    return resultItem.getHyperlinkInfo();
                }
            }
            return info;
        }

        public NextAction getNextAction() {
            return this.myNextAction;
        }

        public void setNextAction(NextAction nextAction) {
            this.myNextAction = nextAction;
        }

        @Nullable
        private static TextAttributes getGrayedHyperlinkAttributes(@NotNull TextAttributesKey normalHyperlinkAttrsKey) {
            TextAttributes normalHyperlinkAttrs;
            if (normalHyperlinkAttrsKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalHyperlinkAttrsKey", "com/intellij/execution/filters/Filter$Result", "getGrayedHyperlinkAttributes"));
            }
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes grayedHyperlinkAttrs = GRAYED_BY_NORMAL_CACHE.get(normalHyperlinkAttrsKey);
            if (grayedHyperlinkAttrs == null && (normalHyperlinkAttrs = globalScheme.getAttributes(normalHyperlinkAttrsKey)) != null) {
                grayedHyperlinkAttrs = normalHyperlinkAttrs.clone();
                grayedHyperlinkAttrs.setForegroundColor(UIUtil.getInactiveTextColor());
                grayedHyperlinkAttrs.setEffectColor(UIUtil.getInactiveTextColor());
                GRAYED_BY_NORMAL_CACHE.put(normalHyperlinkAttrsKey, grayedHyperlinkAttrs);
            }
            return grayedHyperlinkAttrs;
        }

        static {
            EditorColorsManager.getInstance().addEditorColorsListener(new EditorColorsListener(){

                @Override
                public void globalSchemeChange(EditorColorsScheme scheme) {
                    GRAYED_BY_NORMAL_CACHE.clear();
                }
            }, ApplicationManager.getApplication());
        }
    }
}

